/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.selectionview.PropertyTabContributorImpl;
import org.simantics.utils.ui.AdaptionUtils;

public abstract class LabelPropertyTabContributor extends PropertyTabContributorImpl {

    protected final Object id;
    
    public LabelPropertyTabContributor(Object id) {
        assert (id != null);
        this.id = id;
    }
    
    @Override
    public Read<String> getPartNameReadRequest(final ISelection forSelection) {

        return new Read<String>() {

            @Override
            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance(graph);
                ModelingResources mr = ModelingResources.getInstance(graph);

        		final Variable variable = AdaptionUtils.adaptToSingle(forSelection, Variable.class);
                final Resource resource = AdaptionUtils.adaptToSingle(forSelection, Resource.class);
                if(resource == null && variable == null) {
                	return "Selection";
                }
                
                Resource r;
                if(variable != null) {
                	r = (Resource)variable.getRepresents(graph);
                } else {
                	r = resource;
                }
                
                if(graph.hasStatement(r, mr.ElementToComponent)) {
                    r = graph.getSingleObject(r, mr.ElementToComponent);
                }
                String label = graph.getPossibleRelatedValue(r, l0.HasLabel);
                if(label != null)
                    return label;
                label = graph.getPossibleRelatedValue(r, l0.HasName);
                if(label != null)
                    return label;
                return "No name for selection";
            }
            
        };
        
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        LabelPropertyTabContributor other = (LabelPropertyTabContributor) obj;
        return id.equals(other.id);
    }

}
