package org.simantics.jfreechart.chart.properties;

public class ChartVariable implements Comparable<ChartVariable>{
	
	private String rvi;
	private String label;
	
	public ChartVariable(String rvi) {
		this.rvi = rvi;
	}
	
	public ChartVariable(String rvi, String label) {
		this.rvi = rvi;
		this.label = label;
	}
	
	public String getRvi() {
		return rvi;
	}
	
	public String getLabel() {
		return label;
	}
	
	@Override
	public String toString() {
		if (label != null)
			return label;
		return rvi;
	}
	
	@Override
	public int hashCode() {
		return rvi.hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (obj.getClass() != getClass())
			return false;
		ChartVariable other = (ChartVariable)obj;
		return rvi.equals(other.rvi);
	}
	
	@Override
	public int compareTo(ChartVariable o) {
		int rvicomp = rvi.compareTo(o.rvi);
		if (rvicomp == 0)
			return 0;
		if (label != null && o.label != null) {
			int labelcomp =  label.compareTo(o.label);
			if (labelcomp != 0)
				return labelcomp;
		}
		return rvicomp;
	}

}
