/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.ChartComposite;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * Tab for displaying a chart
 * @author Teemu Lempinen
 *
 */
public class ChartTab extends LabelPropertyTabContributor implements Widget {

    public ChartTab(Object id) {
        super(id);
    }

    private Composite parent;

    @Override
    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register(this);
        this.parent = body;
    }

    @Override
    public void setInput(ISessionContext context, final Object input) {
        Resource chart = AdaptionUtils.adaptToSingle(input, Resource.class);
        new ChartComposite(parent, chart, SWT.BORDER);
    }
    
    public Composite getParent() {
		return parent;
	}

}
