/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.ge;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Child rule for obtaining series in a chart. 
 * Assumes that the chart has only one plot and that plot has only one dataset
 * @author Teemu Lempinen
 *
 */
public class SeriesChildRule implements ChildRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if(!(parent instanceof Resource))
            return result;
        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
        Layer0 l0 = Layer0.getInstance(graph);
        /*
         * 1. we assume that there is only one plot
         * 2. we assume that the only plot has only one dataset
         */
        Resource plot = graph.syncRequest(new PossibleObjectWithType((Resource)parent, l0.ConsistsOf, jfree.Plot));
        
        Resource dataset = graph.syncRequest(new PossibleObjectWithType(plot, l0.ConsistsOf, jfree.Dataset));
        
        Resource seriesList = graph.getPossibleObject(dataset, jfree.Dataset_seriesList);
        if(seriesList != null)
            for(Resource series : ListUtils.toList(graph, seriesList)) {
                result.add(series);
            }
        return result;
    }
    
    @Override
    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return new ArrayList<Resource>();
    }

}
