/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.jfree.chart.axis.Axis;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

/**
 * Class representing a JFreeChart.NumberAxis
 * 
 * @author Teemu Lempinen
 *
 */
public class NumberAxis extends AbstractAxis {

    /**
     *
     * @param graph ReadGraph
     * @param axisResource resource of type JFreeChart.NumberAxis
     */
    public NumberAxis(ReadGraph graph, Resource axisResource) {
        super(graph, axisResource);
    }


    @Override
    public Axis getAxis() {
        axis = new ExtendedNumberAxis();
        ((org.jfree.chart.axis.NumberAxis)axis).setAutoRangeIncludesZero(false);
        ((ExtendedNumberAxis)axis).setLower(min);
        ((ExtendedNumberAxis)axis).setUpper(max);
        return super.getAxis();
    }

}
