/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

public class DeviationRenderer extends AbstractRenderer {

    public DeviationRenderer(ReadGraph graph, Resource resource) {
        super(graph, resource);
    }

    private org.jfree.chart.renderer.xy.DeviationRenderer renderer;
    
    @Override
    public org.jfree.chart.renderer.AbstractRenderer getRenderer() {
        if(renderer == null) {
            renderer = new org.jfree.chart.renderer.xy.DeviationRenderer();
            renderer.setDefaultToolTipGenerator(new StandardXYToolTipGenerator());
        }
        return renderer;
    }

}
