package org.simantics.jdbc.variable;

import org.simantics.simulator.toolkit.StandardNodeManager;
import org.simantics.simulator.toolkit.StandardRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCRealm extends StandardRealm<JDBCNode, JDBCNodeManagerSupport> {

    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCRealm.class);

    protected JDBCRealm(JDBCNodeManagerSupport engine, String id) {
        super(engine, id);
    }

    @Override
    protected StandardNodeManager<JDBCNode, JDBCNodeManagerSupport> createManager() {
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("Creating {} for realm with id {}", JDBCNodeManager.class.getSimpleName(), getId());
        return new JDBCNodeManager(this, new JDBCNode("ROOT"));
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

}
