/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui;

import java.util.Map;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ui.Messages;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.strings.StringUtils;

public class IssueLabelRule
implements LabelRule {
    public static final IssueLabelRule INSTANCE = new IssueLabelRule();
    private static final String[] COLS = new String[]{"single", Messages.IssueLabelRule_Resource, Messages.IssueLabelRule_Path};

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    private static String safeStringProperty(ReadGraph graph, Variable v, String property) throws DatabaseException {
        try {
            return StringUtils.safeString((String)((String)v.getPossiblePropertyValue(graph, property)));
        }
        catch (PendingVariableException pendingVariableException) {
            return "";
        }
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Variable issue = (Variable)content;
        String description = IssueLabelRule.safeStringProperty(graph, issue, "HasDescription");
        String resource = IssueLabelRule.safeStringProperty(graph, issue, "resource");
        String path = IssueLabelRule.safeStringProperty(graph, issue, "path");
        Object[] result = new String[]{description, resource, path};
        return new ArrayMap((Object[])COLS, result);
    }
}

