/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.HideFunction;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.Function1;

public class All {
    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String defaultDescription(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return context.getParent(graph).getLabel(graph);
    }

    @SCLValue(type="a -> b -> c")
    public static Object dependencyBaseRealizationFunction(Object _graph, Object _model) throws DatabaseException {
        Resource model = (Resource)_model;
        return model;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueSeverity(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource issue = property.getParent(graph).getRepresents(graph);
        Resource severity = graph.getPossibleObject(issue, ISSUE.Issue_HasSeverity);
        if (severity == null) {
            return "Undefined";
        }
        return (String)graph.getPossibleRelatedValue(severity, L0.HasName, (Binding)Bindings.STRING);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueResource(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
        if (contexts.isEmpty()) {
            return "";
        }
        Resource context = contexts.get(0);
        String name = (String)graph.getPossibleRelatedValue(context, L0.HasName, (Binding)Bindings.STRING);
        if (name != null && !name.isEmpty()) {
            return name;
        }
        if (!graph.hasStatement(context)) {
            return "Removed - please run batch validations";
        }
        return context.toString();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String standardIssuePath(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
        if (contexts.isEmpty()) {
            return "";
        }
        Resource parent = graph.getPossibleObject(contexts.get(0), L0.PartOf);
        if (parent == null) {
            return "";
        }
        Resource issueRoot = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)property);
        if (issueRoot == null) {
            return "";
        }
        Resource contextRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(parent));
        if (contextRoot == null) {
            return "";
        }
        if (issueRoot.equals(contextRoot)) {
            String contextURI;
            String uri = graph.getURI(parent);
            if (uri.equals(contextURI = graph.getURI(contextRoot))) {
                return "";
            }
            return IssueUtils.pathString(uri, contextURI.length() + 1);
        }
        String uri = graph.getURI(parent);
        String modelURI = graph.getURI(graph.getRootLibrary());
        return IssueUtils.pathString(uri, modelURI.length() + 1);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> [Resource]")
    public static List<Resource> standardIssueContexts(ReadGraph graph, Resource converter, Object property) throws DatabaseException {
        if (property instanceof Variable) {
            return IssueUtils.getContextsForProperty(graph, (Variable)property);
        }
        if (property instanceof Resource) {
            Resource issue = (Resource)property;
            IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
            Resource list = graph.getPossibleObject(issue, ISSUE.Issue_HasContexts);
            if (list != null) {
                return ListUtils.toList((ReadGraph)graph, (Resource)list);
            }
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("Unsupported property type: " + String.valueOf(property));
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Function1<Boolean, Boolean> standardIssueHider(ReadGraph graph, Resource converter, Object property) throws DatabaseException {
        Variable hider;
        Variable issue;
        Resource r;
        if (property instanceof Variable && (r = (issue = (hider = (Variable)property).getParent(graph)).getPossibleRepresents(graph)) != null) {
            return new HideFunction(r);
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardIssueHidden(ReadGraph graph, Resource converter, Object property) throws DatabaseException {
        Variable hidden;
        Variable issue;
        Resource r;
        if (property instanceof Variable && (r = (issue = (hidden = (Variable)property).getParent(graph)).getPossibleRepresents(graph)) != null) {
            IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
            return graph.hasStatement(r, ISSUE.Hidden);
        }
        return false;
    }
}

