package org.simantics.issues.common;

import org.simantics.db.Resource;
import org.simantics.issues.Severity;


public class SimpleIssue {
    public static final SimpleIssue[] EMPTY_ARRAY = new SimpleIssue[0];
    
    public final String label;
    public final Severity severity;
    // Optional, not used for equals/hashCode
    public final Resource issueResource;
    
    public SimpleIssue(String label, Severity severity) {
        this(label, severity, null);
    }
    
    public SimpleIssue(String label, Severity severity, Resource issueResource) {
        if(label == null)
            throw new NullPointerException();
        if(severity == null)
            throw new NullPointerException();
        this.label = label;
        this.severity = severity;
        this.issueResource = issueResource;
    }

    @Override
    public int hashCode() {
        return 31*label.hashCode() + severity.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SimpleIssue other = (SimpleIssue) obj;
        return severity.equals(other.severity) && label.equals(other.label);                
    }
}
