/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.csv;

import java.util.ArrayList;
import java.util.List;

public enum ExportInterpolation {
    PREVIOUS_SAMPLE("Previous sample", "previous"),
    LINEAR_INTERPOLATION("Linear interpolation", "lerp");

    public String label;
    public String preference;

    private ExportInterpolation(String label, String preference) {
        this.label = label;
        this.preference = preference;
    }

    public static List<ExportInterpolation> list() {
        return ExportInterpolation.toList(LINEAR_INTERPOLATION, PREVIOUS_SAMPLE);
    }

    public static ExportInterpolation fromIndex(int index) {
        return ExportInterpolation.list().get(index);
    }

    public static ExportInterpolation fromPreference(String preference) {
        for (ExportInterpolation s : ExportInterpolation.list()) {
            if (!s.preference.equals(preference)) continue;
            return s;
        }
        return ExportInterpolation.list().get(0);
    }

    public int index() {
        return ExportInterpolation.list().indexOf((Object)this);
    }

    public static ExportInterpolation getDefault() {
        return LINEAR_INTERPOLATION;
    }

    public String toPreference() {
        return this.preference;
    }

    private static <T> List<T> toList(T ... ts) {
        ArrayList<T> result = new ArrayList<T>();
        T[] TArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            result.add(t);
            ++n2;
        }
        return result;
    }
}

