/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.csv;

public enum DecimalSeparator {
    DOT("Dot (.)", "."),
    COMMA("Comma (,)", ",");

    public String label;
    public String preference;

    private DecimalSeparator(String label, String preference) {
        this.label = label;
        this.preference = preference;
    }

    public static DecimalSeparator fromIndex(int index) {
        return DecimalSeparator.values()[index];
    }

    public String toPreference() {
        return this.preference;
    }

    public static DecimalSeparator fromPreference(String preference) {
        DecimalSeparator[] decimalSeparatorArray = DecimalSeparator.values();
        int n = decimalSeparatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecimalSeparator s = decimalSeparatorArray[n2];
            if (s.preference.equals(preference)) {
                return s;
            }
            ++n2;
        }
        return DOT;
    }

    public static DecimalSeparator fromChar(char c) {
        String preference = "" + c;
        DecimalSeparator[] decimalSeparatorArray = DecimalSeparator.values();
        int n = decimalSeparatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecimalSeparator s = decimalSeparatorArray[n2];
            if (s.preference.equals(preference)) {
                return s;
            }
            ++n2;
        }
        return DOT;
    }
}

