/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.simantics.databoard.binding.Binding;
import org.simantics.history.Collector;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.impl.FileHistory;
import org.simantics.history.impl.FlushPolicy;
import org.simantics.history.impl.MemoryHistory;
import org.simantics.history.util.HistoryExportUtil;

public class History {
    public static HistoryManager openFileHistory(File workarea) {
        return new FileHistory(workarea);
    }

    public static HistoryManager createMemoryHistory() {
        return new MemoryHistory();
    }

    public static Collector createCollector(HistoryManager historyManager) {
        CollectorImpl result = new CollectorImpl(historyManager);
        return result;
    }

    public static Collector createCollector(HistoryManager historyManager, FlushPolicy flushPolicy) {
        CollectorImpl result = new CollectorImpl(historyManager);
        result.setFlushPolicy(flushPolicy);
        return result;
    }

    public static void exportHistory(HistoryManager history, Binding timeBinding, Double from, Double end, OutputStream os) throws IOException, HistoryException {
        HistoryExportUtil eu = new HistoryExportUtil();
        eu.exportHistory(history, timeBinding, from, end, os);
    }

    public static void importHistory(HistoryManager history, InputStream is) throws IOException, HistoryException {
        HistoryExportUtil eu = new HistoryExportUtil();
        eu.importHistory(history, is);
    }
}

