/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.test;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.history.impl.CollectorState;
import org.simantics.history.impl.CollectorState.Item;

public class TestXYZ {

	public static void main(String[] args) throws Exception {
		
		CollectorState.Item cs = new CollectorState.Item();
		Binding b = Bindings.getBinding(CollectorState.Item.class);
		cs = (CollectorState.Item) b.createDefault();
		Serializer s = Bindings.getSerializer(b);
		byte[] dat = s.serialize(cs);
		cs = (Item) s.deserialize(dat);
		System.out.println(b.toString(cs));
		
		Variant v = new Variant(b, cs);
		Serializer vs = Bindings.getSerializer( Bindings.VARIANT );
		byte[] data = vs.serialize(v);		
		v = (Variant) vs.deserialize(data);
		System.out.println(v);
		
		Binding b2 = Bindings.getBinding( b.type() );
		Object cs2 = Bindings.adapt(cs, b, b2);
		System.out.println(b2.toString(cs2));
	}
	
}
