/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.internal.process;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.simantics.graphviz.Activator;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Graphs;
import org.simantics.graphviz.continuation.ComputationThread;

public class CreateXDot
extends ComputationThread<Graph> {
    Graph graph;
    String algorithm;
    Process process;

    public CreateXDot(Graph graph, String algorithm) {
        this.graph = graph;
        this.algorithm = algorithm;
    }

    @Override
    protected void failWith(Exception exception) {
        this.process.destroy();
        super.failWith(exception);
    }

    @Override
    public void run() {
        try {
            File DOT_EXE = Activator.getDotExe();
            this.process = new ProcessBuilder(DOT_EXE.toString(), "-Txdot", "-K" + this.algorithm).directory(DOT_EXE.getParentFile()).start();
            new Thread(){

                @Override
                public void run() {
                    PrintStream stream = new PrintStream(CreateXDot.this.process.getOutputStream());
                    CreateXDot.this.graph.write(stream);
                    stream.close();
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try {
                        int c;
                        InputStream errorStream = CreateXDot.this.process.getErrorStream();
                        while ((c = errorStream.read()) > 0) {
                            System.err.print((char)c);
                        }
                        errorStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            InputStream inputStream = this.process.getInputStream();
            byte[] buffer = Graphs.read(inputStream);
            inputStream.close();
            if (!this.isDone()) {
                this.doneWith(Graphs.parse(new ByteArrayInputStream(buffer)));
            }
        }
        catch (Exception e) {
            this.failWith(e);
        }
    }
}

