/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.graphviz.AbstractIdentifiableGraphPart;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.IGraphPart;

public class Subgraph
extends AbstractIdentifiableGraphPart
implements IGraph {
    Collection<IGraphPart> parts = new ArrayList<IGraphPart>();
    int curId = 0;

    public Subgraph(IGraph parent) {
        super(parent);
    }

    @Override
    public void addPart(IGraphPart part) {
        this.parts.add(part);
    }

    @Override
    public String newId() {
        return this.getId() + "_" + ++this.curId;
    }

    @Override
    public Collection<IGraphPart> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }

    @Override
    public void write(PrintStream s) {
        s.print("subgraph ");
        s.print(this.id);
        s.println(" {");
        s.print("graph");
        this.writeAttributes(s);
        for (IGraphPart part : this.parts) {
            part.write(s);
        }
        s.println("};");
    }
}

