/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.simantics.graphviz.Activator;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.continuation.Computation;
import org.simantics.graphviz.drawable.GraphDrawable;
import org.simantics.graphviz.drawable.JViewer;
import org.simantics.graphviz.internal.parser.DotParser;
import org.simantics.graphviz.internal.parser.ParseException;
import org.simantics.graphviz.internal.process.CreateXDot;

public class Graphs {
    private Graphs() {
    }

    public static Graph parse(InputStream stream) throws IOException {
        try {
            return new DotParser(stream).document();
        }
        catch (ParseException e) {
            System.out.println(e.currentToken.beginLine + ":" + e.currentToken.beginColumn + " - " + e.currentToken.endLine + ":" + e.currentToken.endColumn);
            throw new IOException(e);
        }
    }

    public static Graph parse(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        Graph graph = Graphs.parse(stream);
        ((InputStream)stream).close();
        return graph;
    }

    public static void createImage(Graph graph, String algorithm, String type, File file) throws IOException {
        System.out.println("Create image");
        if (type.equals("dot")) {
            PrintStream stream = new PrintStream(new FileOutputStream(file));
            graph.write(stream);
            stream.close();
        } else {
            int c;
            File DOT_EXE = Activator.getDotExe();
            Process process = new ProcessBuilder(DOT_EXE.toString(), "-T" + type, "-K" + algorithm, "-o" + file.getAbsolutePath()).directory(DOT_EXE.getParentFile()).start();
            PrintStream stream = new PrintStream(process.getOutputStream());
            graph.write(stream);
            stream.close();
            InputStream errorStream = process.getErrorStream();
            while ((c = errorStream.read()) > 0) {
                System.err.print((char)c);
            }
            errorStream.close();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static Computation<Graph> createXDot(Graph graph, String algorithm) {
        CreateXDot process = new CreateXDot(graph, algorithm);
        process.start();
        return process;
    }

    public static byte[] read(InputStream stream) throws IOException {
        byte[] buffer = new byte[1024];
        int pos = 0;
        int len;
        while ((len = stream.read(buffer, pos, buffer.length - pos)) >= 0) {
            if ((pos += len) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, (int)((double)buffer.length * 1.5));
        }
        return Arrays.copyOf(buffer, pos);
    }

    public static void show(final Graph graph, final String algorithm) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JViewer(new GraphDrawable(graph, algorithm));
            }
        });
    }

    public static void show(Graph graph) {
        Graphs.show(graph, "dot");
    }

    public static void showWithNamedWindow(final String windowName, final Graph graph, final String algorithm) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewer.getOrCreateViewer(windowName, new GraphDrawable(graph, algorithm));
            }
        });
    }
}

