/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.graphviz.AbstractAttributeContainer;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.IGraphPart;

public class Graph
extends AbstractAttributeContainer
implements IGraph {
    Collection<IGraphPart> parts = new ArrayList<IGraphPart>();
    int curId = 0;

    public Graph() {
    }

    public Graph(String label) {
        this.setLabel(label);
    }

    @Override
    public void addPart(IGraphPart part) {
        this.parts.add(part);
    }

    @Override
    public String newId() {
        return "n" + ++this.curId;
    }

    @Override
    public Collection<IGraphPart> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }

    public void write(PrintStream s) {
        s.print("digraph {");
        s.print("graph");
        this.writeAttributes(s);
        for (IGraphPart part : this.parts) {
            part.write(s);
        }
        s.println("}");
    }

    public String toString() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        this.write(new PrintStream(ba));
        return ba.toString();
    }

    public void setLabel(String label) {
        this.set("label", label);
    }

    public void setFontColor(String color) {
        this.set("fontcolor", color);
    }

    public void setRankdir(String rankdir) {
        this.set("rankdir", rankdir);
    }

    public void setRanksep(double ranksep, boolean equally) {
        this.set("ranksep", Double.toString(ranksep) + (equally ? " equally" : ""));
    }
}

