/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.internal.xdot;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;

public class Shapes {
	public static Path2D createPolyline(double[] p) {
		Path2D path = new Path2D.Double();
		path.moveTo(p[0], -p[1]);
		for(int i=2;i<p.length;i+=2)
			path.lineTo(p[i], -p[i+1]);
		return path;
	}
	
	public static Path2D createPolygon(double[] p) {
		Path2D path = createPolyline(p);
		path.closePath();
		return path;
	}
	
	public static Path2D createBSpline(double[] p) {
		Path2D.Double path = new Path2D.Double();
		path.moveTo(p[0], p[1]);
		double cp2x = 0.5 * (p[2] + p[4]);
		double cp2y = 0.5 * (p[3] + p[5]);
		double newCp1x = (2.0/3.0) * p[4] + (1.0/3.0) * p[6];
		double newCp1y = (2.0/3.0) * p[5] + (1.0/3.0) * p[7];
		path.curveTo(
				p[2], p[3],
				cp2x, cp2y,
				0.5*(cp2x + newCp1x), 0.5*(cp2y + newCp1y)				
				);
		for(int i=4;i<p.length-8;i+=2) {
			double cp1x = newCp1x;
			double cp1y = newCp1y;
			cp2x = (1.0/3.0) * p[i] + (2.0/3.0) * p[i+2];
			cp2y = (1.0/3.0) * p[i+1] + (2.0/3.0) * p[i+3];
			newCp1x = (2.0/3.0) * p[i+2] + (1.0/3.0) * p[i+4];
			newCp1y = (2.0/3.0) * p[i+3] + (1.0/3.0) * p[i+5];
			path.curveTo(
					cp1x, cp1y,
					cp2x, cp2y,
					0.5*(cp2x + newCp1x), 0.5*(cp2y + newCp1y)				
					);	
		}	
		{
			double cp1x = newCp1x;
			double cp1y = newCp1y;
			cp2x = (1.0/3.0) * p[p.length-8] + (2.0/3.0) * p[p.length-6];
			cp2y = (1.0/3.0) * p[p.length-7] + (2.0/3.0) * p[p.length-5];
			newCp1x = 0.5 * (p[p.length-6] + p[p.length-4]);
			newCp1y = 0.5 * (p[p.length-5] + p[p.length-3]);
			path.curveTo(
					cp1x, cp1y,
					cp2x, cp2y,
					0.5*(cp2x + newCp1x), 0.5*(cp2y + newCp1y)				
					);
			path.curveTo(
					newCp1x, newCp1y,
					p[p.length-4], p[p.length-3],
					p[p.length-2], p[p.length-1]				
					);
		}
		return path;
	}
	
	public static Path2D createCubicSegments(double[] p) {
		Path2D.Double path = new Path2D.Double();
		path.moveTo(p[0], -p[1]);
		for(int i=2;i<p.length;i+=6) {
			path.curveTo(p[i],-p[i+1],p[i+2],-p[i+3],p[i+4],-p[i+5]);
		}
		return path;
	}
	
	public static Ellipse2D createEllipse(double x, double y, double w, double h) {
		return new Ellipse2D.Double(x-w, -y-h, w*2.0, h*2.0);
	}
}
