/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.hack;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.graphfile.Activator;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;

public class GraphJavaFile
extends File {
    private static final long serialVersionUID = 8213749101292672725L;
    private Session session;
    private Resource fileResource;

    public GraphJavaFile(Resource fileResource) {
        super("");
        this.fileResource = fileResource;
        this.session = Simantics.getSession();
    }

    private byte[] getResourceData(ReadGraph graph) throws DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        return (byte[])graph.getRelatedValue(this.fileResource, gf.HasFiledata);
    }

    private byte[] getResourceData() throws DatabaseException {
        return (byte[])Simantics.getSession().syncRequest((Read)new Read<byte[]>(){

            public byte[] perform(ReadGraph graph) throws DatabaseException {
                return GraphJavaFile.this.getResourceData(graph);
            }
        });
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean createNewFile() throws IOException {
        return false;
    }

    @Override
    public boolean delete() {
        try {
            this.session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.deny(GraphJavaFile.this.fileResource);
                }
            });
            return true;
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, "Failed to delete file resource " + String.valueOf(this.fileResource), (Throwable)e));
            return false;
        }
    }

    @Override
    public void deleteOnExit() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        GraphJavaFile other = (GraphJavaFile)obj;
        return this.fileResource.equals(other.fileResource);
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public boolean exists() {
        try {
            return (Boolean)this.session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
                    if (graph.getPossibleRelatedValue(GraphJavaFile.this.fileResource, gf.HasFiledata) != null) {
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, "exists check failed for file resource " + String.valueOf(this.fileResource), (Throwable)e));
            return false;
        }
    }

    @Override
    public String getAbsolutePath() {
        return null;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return null;
    }

    @Override
    public long getFreeSpace() {
        return 0L;
    }

    @Override
    public String getName() {
        try {
            return (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    return (String)graph.getRelatedValue(GraphJavaFile.this.fileResource, l0.HasName);
                }
            });
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, "getName failed for file resource " + String.valueOf(this.fileResource), (Throwable)e));
            return e.getMessage();
        }
    }

    @Override
    public String getParent() {
        return null;
    }

    @Override
    public File getParentFile() {
        return null;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public long getTotalSpace() {
        return 0L;
    }

    @Override
    public long getUsableSpace() {
        return 0L;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.fileResource.hashCode();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        try {
            return (Long)Simantics.getSession().syncRequest((Read)new Read<Long>(){

                public Long perform(ReadGraph graph) throws DatabaseException {
                    GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
                    return (Long)graph.getRelatedValue(GraphJavaFile.this.fileResource, gf.LastModified);
                }
            });
        }
        catch (DatabaseException databaseException) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return this.getResourceData().length;
        }
        catch (DatabaseException databaseException) {
            return 0L;
        }
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean mkdirs() {
        return false;
    }

    @Override
    public boolean renameTo(File dest) {
        return false;
    }

    @Override
    public boolean setReadable(boolean readable) {
        return false;
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return false;
    }

    @Override
    public boolean setWritable(boolean writable) {
        return false;
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return false;
    }

    @Override
    public boolean setExecutable(boolean executable) {
        return false;
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return false;
    }

    @Override
    public boolean setLastModified(long time) {
        return false;
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return null;
    }

    @Override
    public File[] listFiles() {
        return null;
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        return null;
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        return null;
    }

    @Override
    public boolean setReadOnly() {
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return null;
    }

    @Override
    public URI toURI() {
        return null;
    }
}

