/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.hack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.graphfile.Activator;
import org.simantics.graphfile.hack.GraphPath;
import org.simantics.graphfile.hack.SystemProject;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;

public class GraphFile
implements IFile {
    private Resource fileResource;
    private IWorkspace workspace;

    public GraphFile(Resource fileResource, IWorkspace ws) {
        this.fileResource = fileResource;
        this.workspace = ws;
    }

    public Resource getFileResource() {
        return this.fileResource;
    }

    private String getResourceName() {
        try {
            return (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    return (String)graph.getPossibleRelatedValue(GraphFile.this.fileResource, l0.HasName);
                }
            });
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, "Failed to get resource name: " + String.valueOf(this.fileResource), (Throwable)e));
            return e.getMessage();
        }
    }

    private byte[] getResourceData() throws DatabaseException {
        return (byte[])Simantics.getSession().syncRequest((Read)new Read<byte[]>(){

            public byte[] perform(ReadGraph graph) throws DatabaseException {
                return GraphFile.this.getResourceData(graph);
            }
        });
    }

    private byte[] getResourceData(ReadGraph graph) throws DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        return (byte[])graph.getRelatedValue(this.fileResource, gf.HasFiledata);
    }

    private long getResourceModificationTime() {
        try {
            return (Long)Simantics.getSession().syncRequest((Read)new Read<Long>(){

                public Long perform(ReadGraph graph) throws DatabaseException {
                    return GraphFile.this.getResourceMofificationTime(graph);
                }
            });
        }
        catch (DatabaseException databaseException) {
            return -1L;
        }
    }

    private long getResourceMofificationTime(ReadGraph graph) throws DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        long time = (Long)graph.getRelatedValue(this.fileResource, gf.LastModified);
        return time;
    }

    private void setResourceModificationTime(final long time) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                GraphFile.this.setResourceModificationTime(graph, time);
            }
        });
    }

    private void setResourceModificationTime(WriteGraph graph, long time) throws DatabaseException {
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(this.fileResource, gf.LastModified, (Object)time);
    }

    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void clearHistory(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public IMarker createMarker(String type) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public IResourceProxy createProxy() {
        return null;
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public boolean exists() {
        return true;
    }

    public IMarker findMarker(long id) throws CoreException {
        return null;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        return null;
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
        return 0;
    }

    public String getFileExtension() {
        String name = this.getResourceName();
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(".");
        if (i > 0) {
            return name.substring(i);
        }
        return null;
    }

    public long getLocalTimeStamp() {
        return 0L;
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        try {
            this.setResourceModificationTime(value);
        }
        catch (DatabaseException e) {
            throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "GraphFile transaction error", (Throwable)e));
        }
        return value;
    }

    public IPath getLocation() {
        return new GraphPath(this);
    }

    public URI getLocationURI() {
        return null;
    }

    public IMarker getMarker(long id) {
        return null;
    }

    public long getModificationStamp() {
        return this.getResourceModificationTime();
    }

    public IContainer getParent() {
        return SystemProject.getDefault();
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        return null;
    }

    public IProject getProject() {
        return SystemProject.getDefault();
    }

    public IPath getProjectRelativePath() {
        return null;
    }

    public IPath getRawLocation() {
        return new GraphPath(this);
    }

    public URI getRawLocationURI() {
        return null;
    }

    public ResourceAttributes getResourceAttributes() {
        return null;
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public int getType() {
        return 1;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean isAccessible() {
        return true;
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isLinked() {
        return false;
    }

    public boolean isLinked(int options) {
        return false;
    }

    public boolean isLocal(int depth) {
        return true;
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean isSynchronized(int depth) {
        return true;
    }

    public boolean isTeamPrivateMember() {
        return false;
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
    }

    public void revertModificationStamp(long value) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setDerived(boolean isDerived) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setReadOnly(boolean readOnly) {
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean contains(ISchedulingRule rule) {
        return this.equals(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.equals(rule);
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public String getCharset() throws CoreException {
        return this.getCharset(true);
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        return "UTF-8";
    }

    public int getEncoding() throws CoreException {
        return 3;
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public IContentDescription getContentDescription() throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public InputStream getContents() throws CoreException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean force) throws CoreException {
        try {
            return new ByteArrayInputStream(this.getResourceData());
        }
        catch (DatabaseException e) {
            throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "GraphFile transaction error", (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return new GraphPath(this);
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public String getName() {
        return this.getResourceName();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setCharset(String newCharset) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.setContents(source.getContents(), force, keepHistory, monitor);
        this.setLocalTimeStamp(source.getModificationTime());
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setContents(source.getContents(), updateFlags, monitor);
        this.setLocalTimeStamp(source.getModificationTime());
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.setContents(source, (keepHistory ? 2 : 0) | (force ? 1 : 0), monitor);
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[1024];
            int count = 0;
            while ((count = source.read(buf)) > 0) {
                os.write(buf, 0, count);
            }
            os.close();
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    long time = System.currentTimeMillis();
                    GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
                    graph.claimLiteral(GraphFile.this.fileResource, gf.HasFiledata, (Object)os.toByteArray());
                    GraphFile.this.setResourceModificationTime(graph, time);
                }
            });
        }
        catch (DatabaseException e) {
            throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "GraphFile transaction error", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "GraphFile IO error", (Throwable)e));
        }
    }

    public Map getPersistentProperties() throws CoreException {
        return null;
    }

    public Map getSessionProperties() throws CoreException {
        return null;
    }

    public boolean isDerived(int options) {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public void setHidden(boolean isHidden) throws CoreException {
    }

    public boolean isHidden(int options) {
        return false;
    }

    public boolean isTeamPrivateMember(int options) {
        return false;
    }

    public IPathVariableManager getPathVariableManager() {
        return null;
    }

    public boolean isVirtual() {
        return false;
    }

    public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.PLUGIN_ID, "not supported"));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GraphFile other = (GraphFile)obj;
        return this.fileResource.equals(other.fileResource);
    }

    public int hashCode() {
        return this.fileResource.hashCode();
    }
}

