/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.ui.editor;

import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.ui.editor.PlainTextEditor;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextEditorDocumentProvider
extends AbstractDocumentProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlainTextEditor.class);
    protected String currentText;

    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        final Resource resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    if (!graph.isInstanceOf(resource, DOC.FileDocument)) {
                        throw new DatabaseException("Invalid input resource for PlainTextEditor: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)resource));
                    }
                    byte[] bytes = (byte[])graph.getPossibleRelatedValue(resource, GF.HasFiledata, (Binding)Bindings.BYTE_ARRAY);
                    PlainTextEditorDocumentProvider.this.currentText = bytes != null ? new String(bytes, StandardCharsets.UTF_8) : "";
                    return new Document(PlainTextEditorDocumentProvider.this.currentText);
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            LOGGER.error("Failed to create document", (Throwable)e);
            return new Document(sw.toString());
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new AnnotationModel();
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        String text;
        ResourceEditorInput input = (ResourceEditorInput)element;
        final Resource resource = input.getResource();
        this.currentText = text = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
                graph.claimLiteral(resource, GF.HasFiledata, (Object)text.getBytes(StandardCharsets.UTF_8));
                graph.claimLiteral(resource, GF.LastModified, (Object)System.currentTimeMillis());
            }
        });
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return true;
    }

    public boolean isReadOnly(Object element) {
        return false;
    }

    public boolean canSaveDocument(Object element) {
        return !this.getDocument(element).get().equals(this.currentText);
    }
}

