/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.ui.editor;

import java.util.function.Supplier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.graphfile.ui.editor.PlainTextEditorDocumentProvider;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;

public class PlainTextEditor
extends TextEditor {
    boolean isDisposed = false;
    ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.extractInputResource());
    ResourceEditorSupport support;

    public PlainTextEditor() {
        this.setDocumentProvider((IDocumentProvider)new PlainTextEditorDocumentProvider());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.support = new ResourceEditorSupport((IEditorPart)this, this.INPUT_VALIDATOR);
        this.support.activateValidation();
        try {
            this.getResourceEditorInput().init(null);
        }
        catch (DatabaseException e) {
            throw new PartInitException("Failed to initialize " + String.valueOf(input), (Throwable)e);
        }
    }

    protected IResourceEditorInput getResourceEditorInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.updatePartName();
    }

    private void updatePartName() {
        this.setPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = () -> this.isDisposed;
            session.asyncRequest((Read)new TitleRequest(null, this.getResourceEditorInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((PlainTextEditor)this).setPartName(arg_0), disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(this.getSite().getId(), this.getResourceEditorInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((PlainTextEditor)this).setTitleToolTip(arg_0), disposedCallback));
        }
    }

    public void dispose() {
        this.isDisposed = true;
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
        super.dispose();
    }
}

