/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphfile.hack;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;

/**
 * FileEditorInputFactory for GraphFiles. Handles loading and saving GraphFile references.
 * 
 * TODO : uses resource id to reference resources. That is unreliable.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class GraphFileEditorInputFactory implements IElementFactory{
	 /**
     * Factory id. The workbench plug-in registers a factory by this name
     * with the "org.eclipse.ui.elementFactories" extension point.
     */
    private static final String ID_FACTORY = "org.simantics.graphfile.hack.GraphFileEditorInputFactory"; //$NON-NLS-1$

    /**
     * Tag for the IFile.fullPath of the file resource.
     */
    private static final String TAG_RESOURCE_ID = "id"; //$NON-NLS-1$

    /**
     * Creates a new factory.
     */
    public GraphFileEditorInputFactory() {
    }

    /* (non-Javadoc)
     * Method declared on IElementFactory.
     */
    public IAdaptable createElement(IMemento memento) {
        // Get the file name.
        String sid = memento.getString(TAG_RESOURCE_ID);
        if (sid == null) {
			return null;
		}
        final long id = Long.parseLong(sid);
        
        Resource fileResource = null;
        try {
        	fileResource = Simantics.getSession().syncRequest(new Read<Resource>() {
	        	@Override
	        	public Resource perform(ReadGraph graph) throws DatabaseException {
	        		  SerialisationSupport support = graph.getService(SerialisationSupport.class);
	        	      try {
	        	    	  Resource r = support.getResource(id);
	        	    	  return r;
	        	      } catch (Exception e) {
	        	    	  return null;
	        	      }
	        		  
	        	}
		});
        } catch (DatabaseException e) {
        	return null;
        }
        
        if (fileResource == null)
        	return null;

        // Get a handle to the IFile...which can be a handle
        // to a resource that does not exist in workspace
        IWorkspace ws = (IWorkspace) ResourcesPlugin.getWorkspace();
        GraphFile file = new GraphFile(fileResource, ws);
        return new GraphFileEditorInput(file);
    }

    /**
     * Returns the element factory id for this class.
     * 
     * @return the element factory id
     */
    public static String getFactoryId() {
        return ID_FACTORY;
    }

    /**
     * Saves the state of the given file editor input into the given memento.
     *
     * @param memento the storage area for element state
     * @param input the file editor input
     */
    public static void saveState(IMemento memento, GraphFileEditorInput input) {
        GraphFile file = (GraphFile)input.getFile();
        memento.putString(TAG_RESOURCE_ID, Long.toString(file.getFileResource().getResourceId()));
    }
}
