/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.store;

import gnu.trove.set.hash.THashSet;
import java.util.regex.Pattern;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.query.Paths;
import org.simantics.graph.store.IdentityStore;

public class PathPattern {
    private static PathPattern EMPTY_PATTERN = new PathPattern(null, null);
    Path prefix;
    Pattern suffix;
    private static String patternStart = "http://";

    private PathPattern(Path prefix, Pattern suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static PathPattern compile(String pattern) {
        if ((pattern = PathPattern.stripPatternPrefix(pattern)) == null) {
            return EMPTY_PATTERN;
        }
        String[] parts = pattern.split("/");
        Path path = Paths.Root;
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            if (PathPattern.containsWildcards(part)) {
                StringBuilder b = new StringBuilder(pattern.length());
                while (i < parts.length) {
                    b.append('/');
                    b.append(parts[i]);
                    ++i;
                }
                return new PathPattern(path, PathPattern.compileGlobPattern(b.toString()));
            }
            path = new PathChild(part, path);
            ++i;
        }
        return new PathPattern(path, null);
    }

    private static String stripPatternPrefix(String pattern) {
        int i = 0;
        while (i < patternStart.length()) {
            if (pattern.length() <= i) {
                return null;
            }
            char c = pattern.charAt(i);
            if (c == '*') {
                return pattern.substring(i);
            }
            if (c != patternStart.charAt(i) && c != '?') {
                return null;
            }
            ++i;
        }
        return pattern.substring(patternStart.length());
    }

    private static boolean containsWildcards(String pattern) {
        return pattern.contains("*") || pattern.contains("?");
    }

    private static Pattern compileGlobPattern(String pattern) {
        int length = pattern.length();
        StringBuilder b = new StringBuilder(2 * length);
        b.append("\\Q");
        int i = 0;
        while (i < length) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    b.append("\\E.*\\Q");
                    break;
                }
                case '?': {
                    b.append("\\E.\\Q");
                    break;
                }
                case '\\': {
                    if (++i >= length) break;
                    c = pattern.charAt(i);
                    if (c == '\\' && i + 1 < length && pattern.charAt(i + 1) == 'E') {
                        ++i;
                        b.append("\\E\\\\E\\Q");
                        break;
                    }
                    if (c == '*' || c == '?') {
                        b.append(c);
                        break;
                    }
                    b.append('\\');
                    b.append(c);
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        b.append("\\E");
        return Pattern.compile(b.toString());
    }

    public String toString() {
        return "(" + String.valueOf(this.prefix) + ", " + String.valueOf(this.suffix) + ")";
    }

    public void search(IdentityStore store, THashSet<Path> result) {
        int id = store.pathToId(this.prefix);
        if (id == -1) {
            return;
        }
        store.findChildren(id, this.prefix, "", this.suffix, result);
    }

    public static void main(String[] args) {
        System.out.println(PathPattern.compile("http://www.simantics.org/*/foo"));
    }
}

