package org.simantics.graph.query;

public class PathRoot implements Path {
	public final String name;

	public PathRoot(String name) {
		this.name = name;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PathRoot other = (PathRoot) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	@Override
	public String toString() {
		if(name.isEmpty())
			return "http:/";
		else
			return name;
	}
	
	@Override
	public void toString(StringBuilder b) {
		if(name.isEmpty())
			b.append("http:/");
		else
			b.append(name);
	}
	
	@Override
	public Path child(String childName) {
		return new PathChild(childName, this);
	}	
}
