package org.simantics.graph.diff;

public class Statement {
	int subject;
	int predicate;
	int inverse;
	int object;
	
	public Statement(int subject, int predicate, int inverse, int object) {
		this.subject = subject;
		this.predicate = predicate;
		this.inverse = inverse;
		this.object = object;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + inverse;
		result = prime * result + object;
		result = prime * result + predicate;
		result = prime * result + subject;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Statement other = (Statement) obj;
		if (inverse != other.inverse)
			return false;
		if (object != other.object)
			return false;
		if (predicate != other.predicate)
			return false;
		if (subject != other.subject)
			return false;
		return true;
	}
	
	public Statement map(int[] map) {
		int mappedSubject = map[subject];
		if(mappedSubject < 0) return null;
		int mappedPredicate = map[predicate];
		if(mappedPredicate < 0) return null;		
		int mappedInverse;
		if(inverse < 0)
			mappedInverse = inverse;
		else {
			mappedInverse = map[inverse];
			if(mappedInverse < 0) return null;
		}
		int mappedObject = map[object];
		if(mappedObject < 0) return null;
		return new Statement(mappedSubject, mappedPredicate, mappedInverse, mappedObject);
	}
}
