/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.CoreInitialization;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class TGToGraphMap {
    private TransferableGraph1 tg;
    private Resource[] resources;
    private Resource RootLibrary;
    private Resource String;
    private Resource InstanceOf;
    private Resource ConsistsOf;
    private Resource PartOf;
    private Resource HasName;
    private Resource NameOf;

    private void findBuiltins(WriteOnlyGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(CoreInitialization.LAYER0 + "String");
        this.InstanceOf = g.getBuiltin(CoreInitialization.LAYER0 + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(CoreInitialization.LAYER0 + "ConsistsOf");
        this.PartOf = g.getBuiltin(CoreInitialization.LAYER0 + "PartOf");
        this.HasName = g.getBuiltin(CoreInitialization.LAYER0 + "HasName");
        this.NameOf = g.getBuiltin(CoreInitialization.LAYER0 + "NameOf");
    }

    private void findBuiltins(ReadGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(CoreInitialization.LAYER0 + "String");
        this.InstanceOf = g.getBuiltin(CoreInitialization.LAYER0 + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(CoreInitialization.LAYER0 + "ConsistsOf");
        this.PartOf = g.getBuiltin(CoreInitialization.LAYER0 + "PartOf");
        this.HasName = g.getBuiltin(CoreInitialization.LAYER0 + "HasName");
        this.NameOf = g.getBuiltin(CoreInitialization.LAYER0 + "NameOf");
    }

    public TGToGraphMap(TransferableGraph1 tg) {
        this.tg = tg;
        this.resources = new Resource[tg.resourceCount];
    }

    public long[] getResources(SerialisationSupport serializer) throws DatabaseException {
        int count = this.resources.length;
        long[] resourceIds = new long[count];
        int i = 0;
        while (i < count) {
            resourceIds[i] = serializer.getRandomAccessId(this.resources[i]);
            ++i;
        }
        return resourceIds;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    private void claimChild(WriteOnlyGraph graph, Resource parent, String name, Resource child) throws DatabaseException {
        Resource nameResource = graph.newResource();
        graph.claim(nameResource, this.InstanceOf, null, this.String);
        graph.claimValue(nameResource, (Object)name, (Binding)Bindings.STRING);
        graph.claim(child, this.HasName, this.NameOf, nameResource);
    }

    public void addMappedOldResources(SerialisationSupport serializer, int[] oldToNew, Resource[] oldResources) throws DatabaseException {
        assert (oldToNew.length == oldResources.length);
        int i = 0;
        while (i < oldToNew.length) {
            int id = oldToNew[i];
            if (id >= 0) {
                this.resources[id] = oldResources[i];
            }
            ++i;
        }
    }

    public void addOldResources(SerialisationSupport serializer, long[] oldResources) throws DatabaseException {
        assert (oldResources.length == this.resources.length);
        int i = 0;
        while (i < oldResources.length) {
            this.resources[i] = serializer.getResource(oldResources[i]);
            ++i;
        }
    }

    public void prepare(ReadGraph graph) throws DatabaseException {
        if (this.RootLibrary == null) {
            this.findBuiltins(graph);
        }
        Resource[] resources = this.resources;
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof External) {
                External def = (External)definition;
                Resource parent = resources[def.parent];
                Resource child = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent), (AsyncProcedure)new TransientCacheAsyncListener())).get(def.name);
                if (child == null) {
                    throw new ResourceNotFoundException(def.name);
                }
                resources[identity.resource] = child;
            } else if (definition instanceof Root) {
                resources[identity.resource] = this.RootLibrary;
            }
            ++n2;
        }
    }

    public void claim(WriteOnlyGraph graph) throws DatabaseException {
        if (this.RootLibrary == null) {
            this.findBuiltins(graph);
        }
        Resource[] resources = this.resources;
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                resources[i] = graph.newResource();
            }
            ++i;
        }
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof Internal) {
                Internal def = (Internal)definition;
                this.claimChild(graph, resources[def.parent], def.name, resources[identity.resource]);
            }
            ++n2;
        }
        int[] statements = this.tg.statements;
        int i2 = 0;
        while (i2 < statements.length) {
            int inv = statements[i2 + 2];
            graph.claim(resources[statements[i2]], resources[statements[i2 + 1]], inv < 0 ? null : resources[inv], resources[statements[i2 + 3]]);
            i2 += 4;
        }
        Value[] valueArray = this.tg.values;
        int n3 = this.tg.values.length;
        n = 0;
        while (n < n3) {
            Value value = valueArray[n];
            graph.claimValue(resources[value.resource], value.value.getValue(), value.value.getBinding());
            ++n;
        }
    }

    public boolean checkClaim(ReadGraph graph) throws DatabaseException {
        if (this.RootLibrary == null) {
            this.findBuiltins(graph);
        }
        Resource[] resources = this.resources;
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                return true;
            }
            ++i;
        }
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof Internal) {
                return true;
            }
            ++n2;
        }
        if (this.tg.statements.length > 0) {
            return true;
        }
        return this.tg.values.length > 0;
    }

    public void deny(WriteGraph graph) throws DatabaseException {
        if (this.RootLibrary == null) {
            this.findBuiltins((ReadGraph)graph);
        }
        Resource[] resources = this.resources;
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof Internal) {
                graph.deny(resources[identity.resource], this.HasName);
            }
            ++n2;
        }
        int[] statements = this.tg.statements;
        int i = 0;
        while (i < statements.length) {
            int inv = statements[i + 2];
            graph.deny(resources[statements[i]], resources[statements[i + 1]], inv < 0 ? null : resources[inv], resources[statements[i + 3]]);
            i += 4;
        }
        Value[] valueArray = this.tg.values;
        int n3 = this.tg.values.length;
        n = 0;
        while (n < n3) {
            Value value = valueArray[n];
            graph.denyValue(resources[value.resource]);
            ++n;
        }
    }

    public boolean checkDeny(ReadGraph graph) throws DatabaseException {
        if (this.RootLibrary == null) {
            this.findBuiltins(graph);
        }
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof Internal) {
                return true;
            }
            ++n2;
        }
        if (this.tg.statements.length > 0) {
            return true;
        }
        return this.tg.values.length > 0;
    }
}

