/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.util.Set;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.db.StreamingTransferableGraphImportProcess;
import org.simantics.graph.db.TransferableGraphImportProcess;

public class MissingDependencyException
extends DatabaseException {
    private static final long serialVersionUID = -1579450497603555931L;
    private final Set<String> missingExternals;

    public MissingDependencyException(Set<String> missingExternals) {
        super(MissingDependencyException.createMessage(missingExternals));
        this.missingExternals = missingExternals;
    }

    public MissingDependencyException(TransferableGraphImportProcess process) {
        this(process.missingExternals);
    }

    public MissingDependencyException(StreamingTransferableGraphImportProcess process) {
        this(process.missingExternals);
    }

    private static String createMessage(Set<String> missingExternals) {
        StringBuilder b = new StringBuilder();
        b.append("The following required items were missing from the database:\r\n");
        for (String missing : missingExternals) {
            b.append(" -" + missing + "\r\n");
        }
        return b.toString();
    }

    public Set<String> getMissingURIs() {
        return this.missingExternals;
    }

    public String getShortExplanation() {
        return "Missing dependencies";
    }
}

