package org.simantics.graph.db;

public interface TGStatusMonitor {

    void status(int percentage);
    boolean isCanceled();

    public static class NullMonitor implements TGStatusMonitor {
        @Override
        public void status(int percentage) {
        }
        @Override
        public boolean isCanceled() {
            return false;
        }
    }

    public static final TGStatusMonitor NULL_MONITOR = new NullMonitor();

    public static class Updater {
        private final TGStatusMonitor monitor;
        private final int total;
        private int low;
        private int high;
        private int current;
        private int worked;

        public Updater(TGStatusMonitor monitor, int lowPercentage, int highPercentage, int totalWork) {
            this.monitor = monitor;
            this.low = lowPercentage;
            this.high = highPercentage;
            this.total = totalWork;
        }

        public int worked(int work) {
            worked += work;
            return current = updatePercentage(monitor, low, high, current, worked, total);
        }
    }

    public static int updatePercentage(TGStatusMonitor monitor, int low, int high, int oldPercentage, int done, int total) {
        int range = high - low;
        int current = low + (range * done) / total;
        if (current != oldPercentage) {
            oldPercentage = current;
            if (monitor != null) 
                monitor.status(oldPercentage);
        }
        return oldPercentage;
    }

}