package org.simantics.graph.db;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.graph.representation.Root;

abstract public class AbstractImportAdvisor2 implements IImportAdvisor2 {
	
	private Collection<RootInfo> rootInfo = new ArrayList<RootInfo>();

	public Collection<Resource> getRoots() {
		ArrayList<Resource> result = new ArrayList<Resource>(rootInfo.size());
		for(RootInfo info : rootInfo) result.add(info.resource);
		return result;
	}
	
	@Override
	public void redirect(Resource temp) {
	}
	
	@Override
	public Collection<RootInfo> getRootInfo() {
		return rootInfo;
	}
	
	public Resource getRoot() {
		if(rootInfo.size() == 1) return rootInfo.iterator().next().resource;
		else throw new IllegalStateException("Expected a single root, got " + rootInfo.size() + " roots.");
	}
	
	protected void addRootInfo(Root root, String name, Resource resource) {
		rootInfo.add(new RootInfo(root, name, resource));
	}

	public Resource getRoot(String name) {
		for(RootInfo info : getRootInfo())
			if(info.name.equals(name)) return info.resource;
		return null;
	}
	
}
