/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.multileveldiagram;

import java.awt.geom.AffineTransform;
import java.util.List;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.multileveldiagram.LayerComposition;
import org.simantics.g2d.multileveldiagram.TransitionDiagram;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ZoomTransitionParticipant
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    TransformUtil util;
    IHintListener compositeHintListener = new IHintListener(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            ZoomTransitionParticipant.this.composition = (List)newValue;
            AffineTransform at = ZoomTransitionParticipant.this.util.getTransform();
            ZoomTransitionParticipant.this._setZoom(at);
        }

        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
            ZoomTransitionParticipant.this.composition = null;
        }
    };
    List<LayerComposition.LayerInfo> composition;
    TransitionFunction function;

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_CANVAS_TRANSFORM")
    public void transformChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (this.composition == null) {
            return;
        }
        if (newValue == null) {
            return;
        }
        AffineTransform at = (AffineTransform)newValue;
        this._setZoom(at);
    }

    public ZoomTransitionParticipant(TransitionFunction function) {
        this.function = function;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        AffineTransform at = (AffineTransform)ctx.getHintStack().getHint(Hints.KEY_CANVAS_TRANSFORM);
        this._setZoom(at);
        super.addedToContext(ctx);
    }

    @Override
    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        if (newDiagram == oldDiagram) {
            return;
        }
        if (oldDiagram != null && newDiagram == null && this.composition != null && oldDiagram.getHint(DiagramHints.KEY_LAYER_COMPOSITION) == this.composition) {
            this.composition = null;
            oldDiagram.removeKeyHintListener(DiagramHints.KEY_LAYER_COMPOSITION, this.compositeHintListener);
        }
        if (newDiagram != null && this.composition == null && newDiagram.getHint(DiagramHints.KEY_LAYER_COMPOSITION) != null) {
            newDiagram.addKeyHintListener(DiagramHints.KEY_LAYER_COMPOSITION, this.compositeHintListener);
            this.composition = (List)newDiagram.getHint(DiagramHints.KEY_LAYER_COMPOSITION);
        }
        if (newDiagram != null && this.util != null) {
            this._setZoom(this.util.getTransform());
        }
    }

    private void _setDiagramAndPhase(IDiagram d, Double newPhase) {
        Double oldPhase = (Double)this.diagram.getHint(TransitionDiagram.KEY_PHASE);
        IDiagram currentDiagram = this.diagram;
        IDiagram nextDiagram = d;
        if (currentDiagram != nextDiagram) {
            this.setHint(DiagramHints.KEY_DIAGRAM, nextDiagram);
            System.out.println("Switching to " + String.valueOf(nextDiagram));
            this.setDirty();
        }
        if (newPhase != null) {
            this.diagram.setHint(TransitionDiagram.KEY_PHASE, newPhase);
            this.setDirty();
        } else if (oldPhase != null) {
            this.diagram.removeHint(TransitionDiagram.KEY_PHASE);
            this.setDirty();
        }
    }

    private void _setZoom(double zoomLevel) {
        if (this.composition == null) {
            return;
        }
        IDiagram d = Diagram.EMPTY_DIAGRAM;
        double phase = 0.0;
        int i = 0;
        while (i < this.composition.size()) {
            LayerComposition.LayerInfo li = this.composition.get(i);
            if (li.ll >= zoomLevel && li.ul <= zoomLevel) {
                d = li.diagram;
                phase = (zoomLevel - li.ul) / (li.ll - li.ul);
                phase = this.function.f(phase);
                phase = Math.min(phase, 1.0);
                phase = Math.max(phase, 0.0);
                break;
            }
            ++i;
        }
        this._setDiagramAndPhase(d, phase);
    }

    private void _setZoom(AffineTransform at) {
        if (this.diagram == null) {
            return;
        }
        if (at == null) {
            this._setZoom(1.0);
            return;
        }
        double scale = GeometryUtils.getScale(at);
        this._setZoom(scale);
    }
}

