/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.slider;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.Resizeable;
import org.simantics.g2d.elementclass.slider.SliderColorProfile;
import org.simantics.g2d.elementclass.slider.SliderHandle;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SliderClass {
    static final SliderInit INITIAL_VALUES = new SliderInit();
    public static final NarrowTrackPaint NARROW_TRACK = new NarrowTrackPaint();
    public static final WideTrackPaint WIDE_TRACK = new WideTrackPaint();
    public static final ElementClass SLIDER = ElementClass.compile(DefaultTransform.INSTANCE, new Resizeable(new Rectangle2D.Double(0.0, 0.0, 100.0, 15.0), new Rectangle2D.Double(0.0, 0.0, 20.0, 8.0), null, null), NARROW_TRACK, SliderHandle.INSTANCE, INITIAL_VALUES, Stateful.ENABLED_BY_DEFAULT);
    public static final ElementClass SLIDER2 = ElementClass.compile(DefaultTransform.INSTANCE, new Resizeable(new Rectangle2D.Double(0.0, 0.0, 100.0, 15.0), new Rectangle2D.Double(0.0, 0.0, 20.0, 8.0), null, null), WIDE_TRACK, SliderHandle.INSTANCE, INITIAL_VALUES, Stateful.ENABLED_BY_DEFAULT);

    static class NarrowTrackPaint
    implements SceneGraph {
        private static final long serialVersionUID = -598729166071503815L;
        public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

        NarrowTrackPaint() {
        }

        @Override
        public void cleanup(IElement e) {
            Node node = (Node)e.removeHint(SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            G2DParentNode node = (G2DParentNode)e.getHint(SG_NODE);
            if (node == null) {
                node = (G2DParentNode)parent.addNode(G2DParentNode.class);
                e.setHint(SG_NODE, node);
            }
            SliderColorProfile colors = (SliderColorProfile)e.getHint(SliderHandle.KEY_SLIDER_COLOR_PROFILE);
            Rectangle2D rect = ElementUtils.getElementBounds(e);
            double height = rect.getHeight() / 4.0;
            double width = rect.getWidth();
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, height, width, height * 2.0);
            ShapeNode track1 = (ShapeNode)node.getOrCreateNode("track1", ShapeNode.class);
            ShapeNode track2 = (ShapeNode)node.getOrCreateNode("track2", ShapeNode.class);
            ShapeNode track2b = (ShapeNode)node.getOrCreateNode("track2b", ShapeNode.class);
            ShapeNode track3 = (ShapeNode)node.getOrCreateNode("track3", ShapeNode.class);
            track3.setColor((Paint)colors.TRACK3);
            track3.setFill(true);
            track3.setShape((Shape)r);
            track3.setZIndex(1);
            track1.setColor((Paint)colors.TRACK1);
            track1.setShape((Shape)r);
            track1.setZIndex(2);
            track2.setColor((Paint)colors.TRACK2);
            track2.setShape((Shape)new Line2D.Double(1.0, height + 1.0, 1.0, height * 3.0 - 1.0));
            track2.setZIndex(3);
            track2b.setColor((Paint)colors.TRACK2);
            track2b.setShape((Shape)new Line2D.Double(1.0, height + 1.0, width - 1.0, height + 1.0));
            track2b.setZIndex(4);
        }
    }

    static class SliderInit
    implements LifeCycle {
        private static final long serialVersionUID = -5228742711389712263L;

        SliderInit() {
        }

        @Override
        public void onElementCreated(IElement e) {
            e.setHint(SliderHandle.KEY_SLIDER_COLOR_PROFILE, SliderColorProfile.DEFAULT);
            e.setHint(SliderHandle.KEY_SLIDER_POSITION, 1.0);
            e.setHint(SliderHandle.KEY_SLIDER_MIN_VALUE, 0.0);
            e.setHint(SliderHandle.KEY_SLIDER_MAX_VALUE, 3.0);
        }

        @Override
        public void onElementActivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementDestroyed(IElement e) {
        }

        @Override
        public void onElementDeactivated(IDiagram d, IElement e) {
        }
    }

    static class WideTrackPaint
    implements SceneGraph {
        private static final long serialVersionUID = -6644140765437819526L;
        public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

        WideTrackPaint() {
        }

        @Override
        public void cleanup(IElement e) {
            Node node = (Node)e.removeHint(SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            G2DParentNode node = (G2DParentNode)e.getHint(SG_NODE);
            if (node == null) {
                node = (G2DParentNode)parent.addNode(G2DParentNode.class);
                e.setHint(SG_NODE, node);
            }
            SliderColorProfile colors = (SliderColorProfile)e.getHint(SliderHandle.KEY_SLIDER_COLOR_PROFILE);
            Rectangle2D rect = ElementUtils.getElementBounds(e);
            double height = rect.getHeight();
            double width = rect.getWidth();
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, width, height);
            ShapeNode track1 = (ShapeNode)node.getOrCreateNode("track1", ShapeNode.class);
            ShapeNode track2 = (ShapeNode)node.getOrCreateNode("track2", ShapeNode.class);
            ShapeNode track2b = (ShapeNode)node.getOrCreateNode("track2b", ShapeNode.class);
            ShapeNode track3 = (ShapeNode)node.getOrCreateNode("track3", ShapeNode.class);
            track3.setColor((Paint)colors.TRACK3);
            track3.setFill(true);
            track3.setShape((Shape)r);
            track3.setZIndex(1);
            track1.setColor((Paint)colors.TRACK1);
            track1.setShape((Shape)r);
            track1.setZIndex(2);
            track2.setColor((Paint)colors.TRACK2);
            track2.setShape((Shape)new Line2D.Double(1.0, 1.0, 1.0, height - 1.0));
            track2.setZIndex(3);
            track2b.setColor((Paint)colors.TRACK2);
            track2b.setShape((Shape)new Line2D.Double(1.0, height - 1.0, width - 1.0, height - 1.0));
            track2b.setZIndex(4);
        }
    }
}

