/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.connection;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.Transform;

public class EdgeTransforms
implements InternalSize,
Resize,
Scale,
Move,
Transform {
    private static final long serialVersionUID = -1675978959634691347L;
    public static final EdgeTransforms INSTANCE = new EdgeTransforms();
    private static final Point2D SCALE = new Point2D.Double(1.0, 1.0);
    private static final Point2D POSITION = new Point2D.Double(0.0, 0.0);
    private static final AffineTransform TRANSLATE = new AffineTransform();

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        if (size == null) {
            size = new Rectangle2D.Double();
        }
        BendsHandler bends = e.getElementClass().getSingleItem(BendsHandler.class);
        Path2D path = bends.getPath(e);
        size.setFrame(path.getBounds2D());
        return size;
    }

    @Override
    public void resize(IElement e, Rectangle2D newSize) {
        BendsHandler bends = e.getElementClass().getSingleItem(BendsHandler.class);
        Path2D path = bends.getPath(e);
        Rectangle2D oldSize = path.getBounds2D();
        double sx = newSize.getWidth() / oldSize.getWidth();
        double sy = newSize.getHeight() / oldSize.getHeight();
        double tx = newSize.getMinX() + oldSize.getMinX();
        double ty = newSize.getMinY() + oldSize.getMinY();
        AffineTransform at = new AffineTransform();
        at.translate(tx, ty);
        at.scale(sx, sy);
        Path2D.Double newPath = new Path2D.Double(path, at);
        bends.setPath(e, newPath);
    }

    @Override
    public Double getFixedAspectRatio(IElement e) {
        return null;
    }

    @Override
    public Rectangle2D getMaximumSize(IElement e) {
        return null;
    }

    @Override
    public Rectangle2D getMinimumSize(IElement e) {
        return null;
    }

    @Override
    public Point2D getMaximumScale(IElement e) {
        return null;
    }

    @Override
    public Point2D getMinimumScale(IElement e) {
        return null;
    }

    @Override
    public Point2D getScale(IElement e) {
        return SCALE;
    }

    @Override
    public Point2D getPosition(IElement e) {
        return POSITION;
    }

    @Override
    public AffineTransform getTransform(IElement e) {
        return TRANSLATE;
    }

    @Override
    public void moveTo(IElement e, double x, double y) {
        BendsHandler bends = e.getElementClass().getSingleItem(BendsHandler.class);
        Path2D path = bends.getPath(e);
        AffineTransform at = new AffineTransform();
        at.translate(x, y);
        Path2D.Double newPath = new Path2D.Double(path, at);
        bends.setPath(e, newPath);
    }

    @Override
    public void setScale(IElement e, Point2D newScale) {
        BendsHandler bends = e.getElementClass().getSingleItem(BendsHandler.class);
        Path2D path = bends.getPath(e);
        AffineTransform at = new AffineTransform();
        at.scale(newScale.getX(), newScale.getY());
        Path2D.Double newPath = new Path2D.Double(path, at);
        bends.setPath(e, newPath);
    }

    @Override
    public void setTransform(IElement e, AffineTransform at) {
        BendsHandler bends = e.getElementClass().getSingleItem(BendsHandler.class);
        Path2D path = bends.getPath(e);
        Path2D.Double newPath = new Path2D.Double(path, at);
        bends.setPath(e, newPath);
    }
}

