/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.element.handler.impl.TextPainter;
import org.simantics.g2d.elementclass.wheel.RotatorHandler;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ShapeClass {
    static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final ElementClass CIRCLE_CLASS = ShapeClass.getShapeClass(new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0));

    public static ElementClass getShapeClass(Shape s) {
        return ElementClass.compile(DefaultTransform.INSTANCE, BorderColorImpl.BLACK, FillColorImpl.WHITE, TextImpl.INSTANCE, new ShapePainter(s), new TextPainter(), new RotatorHandler());
    }

    static class ShapePainter
    implements SceneGraph,
    Outline,
    InternalSize {
        private static final long serialVersionUID = 2328124349273536527L;
        Shape shape;
        Rectangle2D bounds;
        public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

        public ShapePainter(Shape shape) {
            this.shape = shape;
            this.bounds = shape.getBounds2D();
        }

        @Override
        public void cleanup(IElement e) {
            Node node = (Node)e.removeHint(SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            AffineTransform at;
            G2DParentNode node = (G2DParentNode)e.getHint(SG_NODE);
            if (node == null) {
                node = (G2DParentNode)parent.addNode(G2DParentNode.class);
                e.setHint(SG_NODE, node);
            }
            if ((at = ElementUtils.getTransform(e)) != null) {
                node.setTransform(at);
            }
            ShapeNode bgnode = (ShapeNode)node.getOrCreateNode("bgnode", ShapeNode.class);
            ShapeNode fgnode = (ShapeNode)node.getOrCreateNode("fgnode", ShapeNode.class);
            Color fc = ElementUtils.getFillColor(e);
            Color bc = ElementUtils.getBorderColor(e);
            fgnode.setColor((Paint)fc);
            fgnode.setFill(true);
            fgnode.setShape(this.shape);
            bgnode.setColor((Paint)bc);
            bgnode.setStroke((Stroke)STROKE);
            bgnode.setScaleStroke(true);
            bgnode.setShape(this.shape);
        }

        @Override
        public Shape getElementShape(IElement e) {
            return this.shape;
        }

        @Override
        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            size.setFrame(this.bounds);
            return size;
        }
    }
}

