/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.utils.TextSegment;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TextEditorImpl
implements TextEditor {
    private static final long serialVersionUID = 7183657432363119779L;
    public static final TextEditor INSTANCE = new TextEditorImpl();
    public static final IHintContext.Key ACTIVE = new IHintContext.KeyOf(Boolean.class, "TEXT_EDITOR_ACTIVE");
    public static final IHintContext.Key TEXT = new IHintContext.KeyOf(String.class, "TEXT_EDIT_TEXT");
    public static final IHintContext.Key MODIFIER = new IHintContext.KeyOf(TextEditor.Modifier.class, "TEXT_MODIFIER");
    public static final IHintContext.Key TEXT_SELECTION = new IHintContext.KeyOf(TextSegment.class, "TEXT_SELECTION");
    public static final IHintContext.Key CARET_POS = new IHintContext.KeyOf(Integer.class, "CARET_POS");

    @Override
    public boolean isActive(IElement e) {
        return ElementUtils.getHintOrDefault(e, ACTIVE, Boolean.FALSE);
    }

    @Override
    public void setActive(IElement e, boolean value) {
        ElementUtils.setOrRemoveHint(e, ACTIVE, value ? Boolean.TRUE : null);
        if (!value) {
            e.removeHint(CARET_POS);
        }
    }

    @Override
    public String getText(IElement e) {
        return (String)e.getHint(TEXT);
    }

    @Override
    public void setText(IElement e, String text) {
        ElementUtils.setOrRemoveHint(e, TEXT, text);
    }

    @Override
    public TextEditor.Modifier getModifier(IElement e) {
        return (TextEditor.Modifier)e.getHint(MODIFIER);
    }

    @Override
    public void setModifier(IElement e, TextEditor.Modifier modifier) {
        ElementUtils.setOrRemoveHint(e, MODIFIER, modifier);
    }

    @Override
    public Integer getCaretPosition(IElement e) {
        Integer pos = (Integer)e.getHint(CARET_POS);
        return pos;
    }

    @Override
    public TextSegment getSelection(IElement e) {
        return (TextSegment)e.getHint(TEXT_SELECTION);
    }

    private static boolean isValidCaretPosition(String s, int pos) {
        int l = s.length();
        return pos >= 0 && pos <= l;
    }

    private static void assertValidCaretPosition(String s, int pos) {
        boolean valid = TextEditorImpl.isValidCaretPosition(s, pos);
        if (!valid) {
            throw new IllegalArgumentException("caret position " + pos + " is out of bounds in text '" + s + "'");
        }
    }

    @Override
    public void setCaretPosition(IElement e, Integer position) {
        if (position == null) {
            e.removeHint(CARET_POS);
        } else {
            String text = this.getText(e);
            Integer old = (Integer)e.getHint(CARET_POS);
            if (position.equals(old)) {
                return;
            }
            TextEditorImpl.assertValidCaretPosition(text, position);
            e.setHint(CARET_POS, position);
        }
    }

    @Override
    public void setSelection(IElement e, TextSegment segment) {
        if (segment == null) {
            e.removeHint(TEXT_SELECTION);
        } else {
            String text = this.getText(e);
            TextSegment old = (TextSegment)e.getHint(TEXT_SELECTION);
            if (segment.equals(old)) {
                return;
            }
            if (!segment.existsIn(text)) {
                throw new IllegalArgumentException("segment " + String.valueOf(segment) + " does not exist in text '" + text + "'");
            }
            e.setHint(TEXT_SELECTION, segment);
        }
    }
}

