/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant.pointertool;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorHandle;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Relationship;
import org.simantics.g2d.diagram.handler.RelationshipHandler;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scenegraph.utils.Quality;
import org.simantics.utils.logging.TimeLogger;

public class TranslateMode
extends AbstractMode {
    @DependencyReflection.Reference
    protected RenderingQualityInteractor quality;
    @DependencyReflection.Dependency
    protected TransformUtil util;
    protected Point2D startingPoint;
    protected Point2D currentPoint;
    protected IMouseCursorHandle cursor;
    protected Collection<IElement> elementsToTranslate = Collections.emptyList();
    protected Collection<IElement> elementsToReallyTranslate = Collections.emptyList();
    protected Collection<IElement> translatedConnections = Collections.emptyList();
    protected Collection<IElement> elementsToDirty = new HashSet<IElement>();
    protected G2DParentNode parent;
    protected SingleElementNode node = null;
    protected double dx;
    protected double dy;

    public TranslateMode(Point2D startingPoint, Point2D currentPoint, int mouseId, Collection<IElement> elements) {
        super(mouseId);
        if (startingPoint == null) {
            throw new NullPointerException("null startingPoint");
        }
        if (currentPoint == null) {
            throw new NullPointerException("null currentPoint");
        }
        if (elements == null) {
            throw new NullPointerException("null elements");
        }
        this.startingPoint = startingPoint;
        this.currentPoint = currentPoint;
        this.elementsToTranslate = elements;
    }

    @Override
    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        if (newDiagram != null) {
            this.processTranslatedSelection(newDiagram, this.elementsToTranslate);
            int i = 0;
            ILookupService lookup = NodeUtil.getLookupService((INode)this.node);
            for (IElement e : this.elementsToReallyTranslate) {
                Node n = (Node)e.getHint(ElementHints.KEY_SG_NODE);
                if (n == null) continue;
                LinkNode link = (LinkNode)this.node.addNode("" + i, LinkNode.class);
                link.setZIndex(i);
                String id = lookup.lookupId((INode)n);
                if (id == null) {
                    id = UUID.randomUUID().toString();
                    lookup.map(id, (INode)n);
                    link.setLookupIdOwner(true);
                }
                link.setDelegateId(id);
                ++i;
            }
        }
    }

    protected void processTranslatedSelection(IDiagram diagram, Collection<IElement> elementsToTranslate) {
        int connectionCount = 0;
        for (IElement e : elementsToTranslate) {
            if (!e.getElementClass().containsClass(ConnectionHandler.class)) continue;
            ++connectionCount;
        }
        if (connectionCount == elementsToTranslate.size()) {
            return;
        }
        this.elementsToReallyTranslate = new HashSet<IElement>(elementsToTranslate);
        this.translatedConnections = new HashSet<IElement>();
        RelationshipHandler erh = diagram.getDiagramClass().getAtMostOneItemOfClass(RelationshipHandler.class);
        if (erh != null) {
            ArrayDeque<IElement> todo = new ArrayDeque<IElement>(elementsToTranslate);
            HashSet visited = new HashSet();
            ArrayList<RelationshipHandler.Relation> relations = new ArrayList<RelationshipHandler.Relation>();
            while (!todo.isEmpty()) {
                Object e = todo.poll();
                if (!visited.add(e)) continue;
                relations.clear();
                erh.getRelations(diagram, e, relations);
                for (RelationshipHandler.Relation r : relations) {
                    if (!Relationship.PARENT_OF.equals(r.getRelationship())) continue;
                    this.elementsToReallyTranslate.remove(r.getObject());
                    if (r.getObject() instanceof IElement) {
                        this.elementsToDirty.add((IElement)r.getObject());
                    }
                    if (visited.contains(r.getObject())) continue;
                    todo.add((IElement)r.getObject());
                }
                if (!(e instanceof IElement)) continue;
                IElement el = (IElement)e;
                if (!el.getElementClass().containsClass(Move.class)) {
                    this.elementsToReallyTranslate.remove(el);
                    continue;
                }
                Collection<IElement> parents = ElementUtils.getParents(el);
                boolean parentIsTranslated = false;
                for (IElement parent : parents) {
                    if (!elementsToTranslate.contains(parent)) continue;
                    parentIsTranslated = true;
                    break;
                }
                if (!parentIsTranslated) continue;
                this.elementsToReallyTranslate.remove(el);
                this.elementsToDirty.add(el);
            }
        }
        ArrayList<Topology.Terminal> terminals = new ArrayList<Topology.Terminal>();
        ArrayList<Topology.Connection> connections = new ArrayList<Topology.Connection>();
        ArrayList<Topology.Connection> connections2 = new ArrayList<Topology.Connection>();
        Topology topology = diagram.getDiagramClass().getSingleItem(Topology.class);
        for (IElement el : new ArrayList<IElement>(this.elementsToReallyTranslate)) {
            ElementClass ec = el.getElementClass();
            TerminalTopology tt = ec.getAtMostOneItemOfClass(TerminalTopology.class);
            if (tt == null) continue;
            terminals.clear();
            tt.getTerminals(el, terminals);
            for (Topology.Terminal terminal : terminals) {
                topology.getConnections(el, terminal, connections);
                for (Topology.Connection conn : connections) {
                    ConnectionHandler ch;
                    IElement connection;
                    ConnectionEntity ce = (ConnectionEntity)conn.edge.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                    if (ce == null || (connection = ce.getConnection()) == null || (ch = connection.getElementClass().getAtMostOneItemOfClass(ConnectionHandler.class)) == null) continue;
                    connections2.clear();
                    ch.getTerminalConnections(connection, connections2);
                    boolean allConnectedNodesSelected = true;
                    for (Topology.Connection conn2 : connections2) {
                        if (this.elementsToReallyTranslate.contains(conn2.node)) continue;
                        allConnectedNodesSelected = false;
                        break;
                    }
                    if (!allConnectedNodesSelected) continue;
                    this.elementsToReallyTranslate.add(connection);
                    this.translatedConnections.add(connection);
                }
            }
        }
        for (IElement el : new ArrayList<IElement>(this.elementsToReallyTranslate)) {
            ConnectionHandler ch = el.getElementClass().getAtMostOneItemOfClass(ConnectionHandler.class);
            if (ch == null) continue;
            boolean anyTerminalConnectionsSelected = false;
            ArrayList<Topology.Connection> terminalConnections = new ArrayList<Topology.Connection>();
            ch.getTerminalConnections(el, terminalConnections);
            for (Topology.Connection conn : terminalConnections) {
                if (!elementsToTranslate.contains(conn.node)) continue;
                anyTerminalConnectionsSelected = true;
                break;
            }
            if (!anyTerminalConnectionsSelected) continue;
            this.translatedConnections.add(el);
            ArrayList<IElement> branchPoints = new ArrayList<IElement>();
            ch.getBranchPoints(el, branchPoints);
            this.elementsToReallyTranslate.addAll(branchPoints);
        }
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        IMouseCursorContext mcc;
        super.addedToContext(ctx);
        if (this.quality != null) {
            this.quality.setStaticQuality(Quality.LOW);
        }
        this.cursor = (mcc = this.getContext().getMouseCursorContext()) == null ? null : mcc.setCursor(this.mouseId, new Cursor(13));
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        if (this.cursor != null) {
            this.cursor.remove();
            this.cursor = null;
        }
        if (this.quality != null) {
            this.quality.setStaticQuality(null);
        }
        super.removedFromContext(ctx);
    }

    public AffineTransform getTransform() {
        double dx = this.currentPoint.getX() - this.startingPoint.getX();
        double dy = this.currentPoint.getY() - this.startingPoint.getY();
        return AffineTransform.getTranslateInstance(dx, dy);
    }

    public Point2D getTranslateVector() {
        double dx = this.currentPoint.getX() - this.startingPoint.getX();
        double dy = this.currentPoint.getY() - this.startingPoint.getY();
        return new Point2D.Double(dx, dy);
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleEvent(Event e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (me.mouseId != this.mouseId) {
                return false;
            }
        }
        if (e instanceof CommandEvent) {
            CommandEvent event = (CommandEvent)e;
            if (event.command.equals((Object)Commands.CANCEL)) {
                this.setDirty();
                this.remove();
                return true;
            }
            if (event.command.equals((Object)Commands.ROTATE_ELEMENT_CCW) || event.command.equals((Object)Commands.DELETE) || event.command.equals((Object)Commands.ROTATE_ELEMENT_CW) || event.command.equals((Object)Commands.FLIP_ELEMENT_HORIZONTAL) || event.command.equals((Object)Commands.FLIP_ELEMENT_VERTICAL)) {
                return true;
            }
        } else {
            if (e instanceof MouseEvent.MouseMovedEvent) {
                return this.move((MouseEvent.MouseMovedEvent)e);
            }
            if (e instanceof MouseEvent.MouseButtonReleasedEvent && ((MouseEvent.MouseButtonEvent)e).button == 1) {
                TimeLogger.resetTimeAndLog(this.getClass(), (String)"handleEvent");
                return this.commit();
            }
        }
        return false;
    }

    protected boolean move(MouseEvent.MouseMovedEvent event) {
        Point2D canvasPos = this.util.controlToCanvas(event.controlPosition, null);
        if (Objects.equals(this.currentPoint, canvasPos)) {
            return true;
        }
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            IElement someElement = null;
            Iterator<IElement> iterator = this.elementsToReallyTranslate.iterator();
            if (iterator.hasNext()) {
                IElement elem;
                someElement = elem = iterator.next();
            }
            if (someElement != null) {
                AffineTransform at = this.node.getTransform();
                Move m = someElement.getElementClass().getSingleItem(Move.class);
                Point2D oldPos = m.getPosition(someElement);
                oldPos.setLocation(oldPos.getX() + at.getTranslateX(), oldPos.getY() + at.getTranslateY());
                snapAdvisor.snap(canvasPos, new Point2D[]{new Point2D.Double(-oldPos.getX() + this.currentPoint.getX(), -oldPos.getY() + this.currentPoint.getY())});
            }
        }
        this.dx = canvasPos.getX() - this.startingPoint.getX();
        this.dy = canvasPos.getY() - this.startingPoint.getY();
        if ((event.stateMask & 0x80) != 0) {
            if (Math.abs(this.dx) >= Math.abs(this.dy)) {
                this.dy = 0.0;
            } else {
                this.dx = 0.0;
            }
        }
        AffineTransform nat = AffineTransform.getTranslateInstance(this.dx, this.dy);
        this.node.setTransform(nat);
        this.currentPoint = canvasPos;
        this.setDirty();
        return true;
    }

    protected boolean commit() {
        TimeLogger.resetTimeAndLog(this.getClass(), (String)"commit");
        for (IElement el : this.elementsToReallyTranslate) {
            Move move = el.getElementClass().getAtMostOneItemOfClass(Move.class);
            if (move == null) continue;
            Point2D oldPos = move.getPosition(el);
            move.moveTo(el, oldPos.getX() + this.dx, oldPos.getY() + this.dy);
        }
        DiagramUtils.mutateDiagram(this.diagram, m -> {
            for (IElement e : this.elementsToReallyTranslate) {
                m.modifyTransform(e);
            }
        });
        for (IElement dirty : this.elementsToDirty) {
            dirty.setHint(Hints.KEY_DIRTY, Hints.VALUE_SG_DIRTY);
        }
        this.setDirty();
        this.remove();
        return false;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.parent = parent;
        this.node = (SingleElementNode)parent.addNode("translate ghost", SingleElementNode.class);
        this.node.setZIndex(1000);
        this.node.setVisible(Boolean.TRUE);
        this.node.setComposite((Composite)AlphaComposite.SrcOver.derive(0.4f));
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        if (this.node != null) {
            this.node.remove();
            this.node = null;
        }
        this.parent = null;
    }
}

