/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler;

import java.util.Collection;
import java.util.Objects;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DiagramHandler;
import org.simantics.g2d.diagram.handler.Relationship;

public interface RelationshipHandler
extends DiagramHandler {
    public void claim(IDiagram var1, Object var2, Relationship var3, Object var4);

    public void deny(IDiagram var1, Object var2, Relationship var3, Object var4);

    public void deny(IDiagram var1, Relation var2);

    public void denyAll(IDiagram var1, Object var2);

    public Collection<Relation> getRelations(IDiagram var1, Object var2, Collection<Relation> var3);

    public static final class Relation {
        private final Object subject;
        private final Relationship relationship;
        private final Object object;

        public Relation(Object subject, Relationship relationship, Object object) {
            assert (subject != null);
            assert (relationship != null);
            assert (object != null);
            this.subject = subject;
            this.relationship = relationship;
            this.object = object;
        }

        public Object getSubject() {
            return this.subject;
        }

        public Relationship getRelationship() {
            return this.relationship;
        }

        public Object getObject() {
            return this.object;
        }

        public int hashCode() {
            return Objects.hashCode(this.subject) * 31 + Objects.hashCode(this.object) * 31 + Objects.hashCode(this.relationship);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Relation)) {
                return false;
            }
            Relation other = (Relation)obj;
            return this.subject.equals(other.subject) && this.object.equals(other.object) && this.relationship.equals(other.relationship);
        }

        public String toString() {
            return "(" + String.valueOf(this.subject) + ", " + String.valueOf(this.relationship) + ", " + String.valueOf(this.object) + ")";
        }
    }
}

