/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.segments.Segment;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.MonitorHandler;
import org.simantics.g2d.elementclass.RouteGraphConnectionClass;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.utils.datastructures.Pair;

public class PickRequest {
    public Shape pickArea;
    public PickPolicy pickPolicy = PickPolicy.PICK_INTERSECTING_OBJECTS;
    public PickFilter pickFilter = null;
    public PickSorter pickSorter = null;
    public IntersectionMode intersectionPolicy = IntersectionMode.POINT;
    public ICanvasContext pickContext;

    public PickRequest(double x, double y) {
        this.pickArea = new Rectangle2D.Double(x, y, 1.0, 1.0);
    }

    public PickRequest(Point2D p) {
        this.pickArea = new Rectangle2D.Double(p.getX(), p.getY(), 1.0E-4, 1.0E-4);
    }

    public PickRequest(Shape shape) {
        this.pickArea = shape;
    }

    public PickRequest(Shape shape, AffineTransform transform) {
        this.pickArea = GeometryUtils.transformShape(shape, transform);
    }

    public PickRequest context(ICanvasContext ctx) {
        this.pickContext = ctx;
        return this;
    }

    public static enum IntersectionMode {
        POINT,
        BOUNDS;

    }

    public static interface PickFilter {
        public static final PickFilter FILTER_ALL = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return true;
            }
        };
        public static final PickFilter FILTER_CONNECTIONS = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(ConnectionHandler.class);
            }

            public String toString() {
                return "FILTER_CONNECTIONS";
            }
        };
        public static final PickFilter FILTER_CONNECTION_EDGES = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(BendsHandler.class) || e.getElementClass().containsClass(ConnectionSelectionOutline.class);
            }

            public String toString() {
                return "FILTER_CONNECTION_EDGES";
            }
        };
        public static final PickFilter FILTER_BRANCH_POINT = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(BranchPoint.class);
            }

            public String toString() {
                return "FILTER_BRANCH_POINTS";
            }
        };
        public static final PickFilter FILTER_NODES = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(TerminalTopology.class);
            }

            public String toString() {
                return "FILTER_NODES";
            }
        };
        public static final PickFilter FILTER_MONITORS = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(MonitorHandler.class);
            }

            public String toString() {
                return "FILTER_MONITORS";
            }
        };

        public boolean accept(IElement var1);
    }

    public static enum PickPolicy {
        PICK_INTERSECTING_OBJECTS,
        PICK_CONTAINED_OBJECTS;

    }

    public static interface PickSorter {
        public static final PickSorter CONNECTIONS_LAST = new PickSorter(){

            @Override
            public void sort(List<IElement> elements) {
                Collections.sort(elements, new Comparator<IElement>(){

                    @Override
                    public int compare(IElement e1, IElement e2) {
                        boolean isConn1 = PickFilter.FILTER_CONNECTION_EDGES.accept(e1);
                        boolean isConn2 = PickFilter.FILTER_CONNECTION_EDGES.accept(e2);
                        if (!isConn1 && isConn2) {
                            return -1;
                        }
                        if (isConn1 && !isConn2) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
        };
        public static final PickSorter CONNECTIONS_FIRST = new PickSorter(){

            @Override
            public void sort(List<IElement> elements) {
                Collections.sort(elements, new Comparator<IElement>(){

                    @Override
                    public int compare(IElement e1, IElement e2) {
                        boolean isConn1 = PickFilter.FILTER_CONNECTION_EDGES.accept(e1);
                        boolean isConn2 = PickFilter.FILTER_CONNECTION_EDGES.accept(e2);
                        if (!isConn1 && isConn2) {
                            return 1;
                        }
                        if (isConn1 && !isConn2) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
        };

        public void sort(List<IElement> var1);

        default public void sort(PickRequest request, List<IElement> elements) {
            this.sort(elements);
        }

        public static PickSorter connectionSorter(final PickSorter sorter, final double x, final double y) {
            return new PickSorter(){

                private double getDistanceSqToRouteGraphConnection(RouteGraphNode rgn, double x2, double y2) {
                    double minDistanceSq = Double.MAX_VALUE;
                    for (RouteLine line : rgn.getRouteGraph().getAllLines()) {
                        ArrayList segments = new ArrayList();
                        line.collectSegments(segments);
                        for (Segment segment : segments) {
                            RoutePoint p1 = segment.p1;
                            RoutePoint p2 = segment.p2;
                            double distanceSq = Line2D.ptSegDistSq(p1.getX(), p1.getY(), p2.getX(), p2.getY(), x2, y2);
                            if (!(distanceSq < minDistanceSq)) continue;
                            minDistanceSq = distanceSq;
                        }
                    }
                    return minDistanceSq;
                }

                private void sortConnections(List<IElement> elements) {
                    ArrayList<Pair> connections = new ArrayList<Pair>(elements.size());
                    int tail = 0;
                    int i = 0;
                    while (i < elements.size()) {
                        IElement element = elements.get(i);
                        RouteGraphNode rgn = (RouteGraphNode)element.getHint(RouteGraphConnectionClass.KEY_RG_NODE);
                        if (rgn != null) {
                            double distanceSq = this.getDistanceSqToRouteGraphConnection(rgn, x, y);
                            connections.add(Pair.make((Object)distanceSq, (Object)element));
                        }
                        if (rgn == null || i == elements.size() - 1) {
                            Collections.sort(connections, new Comparator<Pair<Double, IElement>>(){

                                @Override
                                public int compare(Pair<Double, IElement> connection1, Pair<Double, IElement> connection2) {
                                    return Double.compare((Double)connection2.first, (Double)connection1.first);
                                }
                            });
                            for (Pair connection : connections) {
                                elements.set(tail, (IElement)connection.second);
                                ++tail;
                            }
                            connections.clear();
                            tail = i + 1;
                        }
                        ++i;
                    }
                }

                @Override
                public void sort(PickRequest request, List<IElement> elements) {
                    if (sorter != null) {
                        sorter.sort(request, elements);
                    }
                    this.sortConnections(elements);
                }

                @Override
                public void sort(List<IElement> elements) {
                    if (sorter != null) {
                        sorter.sort(elements);
                    }
                    this.sortConnections(elements);
                }
            };
        }
    }
}

