package org.simantics.g2d.tooltip;

import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseExitEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseMovedEvent;

/**
 * Tooltip support for diagram elements.
 *
 */
public class ElementTooltipParticipant extends BaseTooltipParticipant {

    public ElementTooltipParticipant() {
    }

    @Dependency PointerInteractor interactor;

    @EventHandler(priority = 0)
    public boolean handleMove(MouseMovedEvent me) {
        if (!me.hasAnyButton(MouseEvent.ALL_BUTTONS_MASK)) {
            IElement e = interactor.getEventTarget(me);
            if (e != null) {
                showTooltipFor(e);
            } else {
                hideTooltip();
            }
        } else {
            hideTooltip();
        }
        return false;
    }

    @EventHandler(priority = 0)
    public boolean mouseExited(MouseExitEvent me) {
        hideTooltip();
        return false;
    }

}
