/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.g2d.routing.algorithm1.Penalty;
import org.simantics.g2d.routing.algorithm1.Rectangle;
import org.simantics.g2d.routing.algorithm1.StopSet;
import org.simantics.g2d.routing.algorithm1.StopSet.IStopProcedure;
import org.simantics.g2d.routing.algorithm1.StopSet.Line;
import org.simantics.g2d.routing.algorithm1.StopSet.Stop;

public class TestStopSet extends Frame {

	private static final long serialVersionUID = 2181877722124429003L;
	
	Collection<Rectangle> rectangles = new ArrayList<Rectangle>();
	Rectangle source;
	Rectangle target;
		
	double startX, startY;
	double curX, curY;
	int mouseButtons = 0;

	public TestStopSet() {
		addWindowListener(new WindowListener() {

			@Override
			public void windowActivated(WindowEvent e) {
			}

			@Override
			public void windowClosed(WindowEvent e) {		
			}

			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);			
			}

			@Override
			public void windowDeactivated(WindowEvent e) {
			}

			@Override
			public void windowDeiconified(WindowEvent e) {
			}

			@Override
			public void windowIconified(WindowEvent e) {
			}

			@Override
			public void windowOpened(WindowEvent e) {
			}
			
		});
		
		addMouseListener(new MouseListener() {

			@Override
			public void mouseClicked(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mouseEntered(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mouseExited(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mousePressed(MouseEvent e) {
				mouseButtons = e.getButton();
				curX = startX = e.getX();
				curY = startY = e.getY();
				if(e.getButton() == MouseEvent.BUTTON2)
					source = null;
				else if(e.getButton() == MouseEvent.BUTTON3)
					target = null;
				repaint();
			}

			@Override
			public void mouseReleased(MouseEvent e) {
				mouseButtons = 0;
				double x0 = startX;
				double y0 = startY;
				double x1 = e.getX();
				double y1 = e.getY();
				if(x0 > x1) {
					double temp = x0;
					x0 = x1;
					x1 = temp;
				}
				if(y0 > y1) {
					double temp = y0;
					y0 = y1;
					y1 = temp;
				}
				Rectangle rect = new Rectangle(x0, y0, x1, y1);
				
				if(e.getButton() == MouseEvent.BUTTON1)				
					rectangles.add(rect);
				else if(e.getButton() == MouseEvent.BUTTON2)
					source = rect;
				else if(e.getButton() == MouseEvent.BUTTON3)
					target = rect;
				
				repaint();				
			}
			
		});
		
		addMouseMotionListener(new MouseMotionListener() {

			@Override
			public void mouseDragged(MouseEvent e) {
				curX = e.getX();
				curY = e.getY();
				repaint();
			}

			@Override
			public void mouseMoved(MouseEvent e) {						
			}
			
		});
		
		setSize(640, 480);
		setVisible(true);
	}
	
	@Override
	public void paint(Graphics _g) {
		final Graphics2D g = (Graphics2D)_g;
		Map<Object, Object> hints = new HashMap<Object, Object>();
		hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		g.addRenderingHints(hints);
		
		/*Path2D path = new Path2D.Double();
		path.moveTo(0.0, 0.0);
		path.lineTo(100.0, 100.0);
		path.lineTo(400.0, 100.0);
				
		g.draw(path);
		*/
		
		g.setColor(Color.GRAY);
		g.setStroke(new BasicStroke(1.0f));
		for(Rectangle rect : rectangles)
			drawRectangle(g, rect.x0, rect.y0, rect.x1, rect.y1);		
		
		if(source != null) {
			g.setColor(Color.BLUE);
			drawRectangle(g, source.x0, source.y0, source.x1, source.y1);
		}
		if(target != null) {
			g.setColor(Color.GREEN);
			drawRectangle(g, target.x0, target.y0, target.x1, target.y1);
		}
		if(mouseButtons != 0) {
			if(mouseButtons == 1)
				g.setColor(Color.BLACK);
			else if(mouseButtons == 2)
				g.setColor(Color.BLUE);
			else if(mouseButtons == 3)
				g.setColor(Color.GREEN);
			drawRectangle(g, startX, startY, curX, curY);
		}
		
		Collection<Stop> stops = new ArrayList<Stop>(rectangles.size());
		Penalty penalty = new Penalty(100.0, 0.0);
		for(Rectangle rect : rectangles)
			stops.add(new Stop(penalty, rect.x0, rect.x1, rect.y0));
		StopSet ss = new StopSet(stops);
		
		if(target != null) {
			g.setColor(Color.GREEN);
			g.setStroke(new BasicStroke(1.0f));
			drawFront(g, ss, target.x0, target.x1, target.y1);
		}
	}
	
	public final double PADDING = 2.0;
	
	void drawFront(final Graphics2D g, final StopSet ss, final double x0, final double x1, final double y) {
		ss.findStops(x0, x1, y, new IStopProcedure() {

			@Override
			public void blockEnd(double y1) {
				if(y1 == Double.POSITIVE_INFINITY)
					y1 = 100000.0;
				Rectangle2D rect = new Rectangle2D.Double(x0 + PADDING, y + PADDING, x1-x0 - PADDING*2, y1-y - PADDING*2);
				g.draw(rect);							
			}

			@Override
			public void continuation(double min, double max, int pos, Line line) {
				drawFront(g, ss, pos, line, min, max);
			}
			
		});
	}
	
	void drawFront(final Graphics2D g, final StopSet ss, int pos, final Line line, final double x0, final double x1) {
		StopSet.continueStop(pos, line, x0, x1, new IStopProcedure() {

			@Override
			public void blockEnd(double y1) {
				if(y1 == Double.POSITIVE_INFINITY)
					y1 = 100000.0;
				Rectangle2D rect = new Rectangle2D.Double(x0 + PADDING, line.y + PADDING, x1-x0 - PADDING*2, y1-line.y - PADDING*2);
				g.draw(rect);							
			}

			@Override
			public void continuation(double min, double max, int pos, Line line) {
				drawFront(g, ss, pos, line, min, max);
			}
			
		});
	}
	
	static void drawRectangle(Graphics2D g, double x0, double y0, double x1, double y1) {
		if(x0 > x1) {
			double temp = x0;
			x0 = x1;
			x1 = temp;
		}
		if(y0 > y1) {
			double temp = y0;
			y0 = y1;
			y1 = temp;
		}
		Rectangle2D rect = new Rectangle2D.Double(x0, y0, x1-x0, y1-y0);
		g.fill(rect);			
	}
	
	Image offScreenImage;
	int offScreenImageWidth;
	int offScreenImageHeight;

	public void update( Graphics g ) {
		if ( offScreenImage == null || getWidth() != offScreenImageWidth || getHeight() != offScreenImageHeight) {
			offScreenImageWidth = getWidth();
			offScreenImageHeight = getHeight();
			offScreenImage = createImage(offScreenImageWidth, offScreenImageHeight);
		}

		Graphics gOffScreenImage = offScreenImage.getGraphics();

		gOffScreenImage.clearRect(0, 0, getWidth(), getHeight());
		paint( gOffScreenImage );

		g.drawImage(offScreenImage, 0, 0, this);

		gOffScreenImage.dispose();
	} 
	
	public static void main(String[] args) {
		new TestStopSet();
	}
	
}
