/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

public class Connection {
	/**
	 * An array containing route points (also the start and end point)
	 */
	public double[] routePath; 
	/**
	 * Combination of the flags defined in Constants:
	 */
	public int startDirections;
	/**
	 * Combination of the flags defined in Constants:
	 */
	public int endDirections;
	
	public Connection(double[] routePoints, int startDirections, int endDirections) {
		this.routePath = routePoints;
		this.startDirections = startDirections;
		this.endDirections = endDirections;
	}
	
	public double minLength() {
		double length = 0.0;
		for(int i=2;i<routePath.length;i+=2) 
			length += Math.abs(routePath[i]-routePath[i-2]) 
				+ Math.abs(routePath[i+1]-routePath[i-1]);
		return length;
	}
}
