/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCaptureContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IContentContext.IContentListener;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;

/**
 * Subcanvas encapsulates a canvas (another) in one participant.
 * 
 * 
 * @author Toni Kalajainen
 */
public class SubCanvas extends AbstractCanvasParticipant {

	@Dependency TransformUtil util;

	private boolean enabled = true;
	private ICanvasContext superCtx = null;
	
	/** Sub-Canvas */
	private ICanvasContext sub;
	int eventPriority, paintPriority, hintPriority;
	//IHintContext subHintStack;
	IMouseCursorContext origSubCursorCtx;
	IMouseCaptureContext origSubCaptureCtx;
	
	// Subcanvas has become dirty, make super canvas also dirty
	IContentListener paintableCtxListener = new IContentListener() {

		@Override
		public void onDirty(IContentContext sender) {
			if (superCtx==null) return;
			superCtx.getContentContext().setDirty();
		}
	};
	
	public SubCanvas(ICanvasContext subCanvas, int eventPriority, int paintPriority, int hintPriority) {
		assert(subCanvas!=null);
		this.sub = subCanvas;
		this.eventPriority = eventPriority;
		this.paintPriority = paintPriority;
		this.hintPriority = hintPriority;
		//subHintStack = sub.getHintStack().createStackRead(sub.getDefaultHintContext());
		
//		subCanvas.getMouseCaptureContext().addMouseCaptureListener(new IMouseCaptureListener() {
//			@Override
//			public void onMouseCaptured(IMouseCaptureContext sender, int mouseId) {
//				if (superCtx==null) return;
//				superCtx.getMouseCaptureContext().
//			}
//			@Override
//			public void onMouseReleased(IMouseCaptureContext sender, int mouseId) {
//			}});
	}
	
	@Override
	public void addedToContext(ICanvasContext ctx) {
		super.addedToContext(ctx);
		superCtx = ctx;
		if (enabled) enable();
	}
	
	@Override
	public void removedFromContext(ICanvasContext ctx) {
		assert(superCtx==ctx);
		if (enabled) disable();
		superCtx = null;
		super.removedFromContext(ctx);
	}
	
	public void setEnabled(boolean enabled)
	{
		if (this.enabled == enabled) return;
		if (enabled) enable(); else disable();
	}
	
	void enable() {
		superCtx.getEventHandlerStack().add(sub.getEventHandlerStack(), eventPriority);
//		superCtx.getPainterStack().add(sub.getPainterStack(), paintPriority);
		//superCtx.getHintStack().addHintContext(subHintStack, hintPriority);
		sub.getContentContext().addPaintableContextListener(paintableCtxListener);
		origSubCursorCtx = sub.getMouseCursorContext();
		sub.setMouseCursorContext(getContext().getMouseCursorContext());
		origSubCaptureCtx = sub.getMouseCaptureContext();
		sub.setMouseCaptureContext(getContext().getMouseCaptureContext());
		assert(sub.getDefaultHintContext().getHint(Hints.KEY_SUPER_CANVAS)==null);
		//sub.getDefaultHintContext().setHint(Hints.KEY_SUPER_CANVAS, ctx);
		this.enabled = true;
	}
	
	void disable() {
		sub.getDefaultHintContext().removeHint(Hints.KEY_SUPER_CANVAS);
		sub.setMouseCaptureContext(origSubCaptureCtx);		
		sub.setMouseCursorContext(origSubCursorCtx);
		sub.getContentContext().removePaintableContextListener(paintableCtxListener);
		//ctx.getHintStack().removeHintContext(subHintStack);
//		superCtx.getPainterStack().remove(sub.getPainterStack());
		superCtx.getEventHandlerStack().remove(sub.getEventHandlerStack());
		this.enabled = false;
	}

}
