/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.notification;

import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DParentNode;

public class PositionedMessage extends AbstractNotification implements INotification {

    private static final double MARGIN = 10;

    String                      message;
    Point2D                     position;
    Font                        font   = new Font("Arial", Font.PLAIN, 14);

    public PositionedMessage(String message, Point2D canvasPosition) {
        this.message = message;
        this.position = canvasPosition;
        this.bounds.setFrame(position.getX(), position.getY(), 0, 0);
    }

    @Override
    public void setBounds(Rectangle2D r) {
        // Intentional NOP
    }

    @Override
    public void update(G2DParentNode parent) {
    }

}
