/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.gallery;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.tooltip.AWTTooltipProvider;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * GalleryViewers tooltip provider
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class GalleryTooltipProvider extends AWTTooltipProvider {
	
	public static Key TOOLTIP_TEXT = new KeyOf(String.class, "TOOLTIP_TEXT");
	public static Key TOOLTIP_IMAGE = new KeyOf(Image.class, "TOOLTIP_IMAGE");

	@Override
	public void constructPopup(Frame frame,IElement element) {
		String text = element.getHint(TOOLTIP_TEXT);
		final Image image = element.getHint(TOOLTIP_IMAGE);
		if (text == null && image == null)
			return;

		frame.setLayout(new BoxLayout(frame, BoxLayout.X_AXIS));
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
		Color c = new Color(255, 255, 220);
		panel.setBackground(c);
		panel.setBorder(BorderFactory.createLineBorder(Color.black));
		
		if (image != null) {
			Canvas canvas = new Canvas() {
				private static final long serialVersionUID = -7357041194563374338L;

				@Override
				public void paint(Graphics g) {
					super.paint(g);
					g.drawImage(image, 0, 0, null);
				}
				
				@Override
				public Dimension getSize() {
					return new Dimension(image.getWidth(null), image.getHeight(null));
				}
				
				@Override
				public Dimension getSize(Dimension rv) {
					if (rv == null)
						rv = new Dimension();
					rv.width = image.getWidth(null);
					rv.height = image.getHeight(null);
					return rv;
				}
			};
			panel.add(canvas);
		}
		if (text != null) {
			JLabel label = new JLabel(text);
			panel.add(label);
		}
		frame.add(panel);

	}

}
