/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.connection;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.Transform;

/**
 * Implements Bounds, Scale, Move and Transform for edges.
 * 
 * @See {@link InternalSize}
 * @See {@link Scale}
 * @See {@link Move}
 * @See {@link Transform}
 * @author Toni Kalajainen
 */
public class EdgeTransforms implements InternalSize, Resize, Scale, Move, Transform {

	private static final long serialVersionUID = -1675978959634691347L;
	public static final EdgeTransforms INSTANCE = new EdgeTransforms(); 

	@Override
	public Rectangle2D getBounds(IElement e, Rectangle2D size) {
		if (size==null) size = new Rectangle2D.Double();
		BendsHandler bends = e.getElementClass().getSingleItem(BendsHandler.class);
		Path2D path = bends.getPath(e);
		size.setFrame(path.getBounds2D());
		return size;
	}

	@Override
	public void resize(IElement e, Rectangle2D newSize) {
		BendsHandler 	bends	= e.getElementClass().getSingleItem(BendsHandler.class);
		Path2D		path	= bends.getPath(e);
		Rectangle2D	oldSize	= path.getBounds2D();
		double		sx		= newSize.getWidth() / oldSize.getWidth();
		double		sy		= newSize.getHeight() / oldSize.getHeight();
		double		tx		= newSize.getMinX() + oldSize.getMinX();
		double		ty		= newSize.getMinY() + oldSize.getMinY();
		AffineTransform at	= new AffineTransform();
		at.translate(tx, ty);
		at.scale(sx, sy);		
		Path2D		newPath	= new Path2D.Double(path, at);
		bends.setPath(e, newPath);
	}
	
	@Override
	public Double getFixedAspectRatio(IElement e) {
		return null;
	}

	@Override
	public Rectangle2D getMaximumSize(IElement e) {
		return null;
	}

	@Override
	public Rectangle2D getMinimumSize(IElement e) {
		return null;
	}

	@Override
	public Point2D getMaximumScale(IElement e) {
		return null;
	}

	@Override
	public Point2D getMinimumScale(IElement e) {
		return null;
	}

	private final static Point2D SCALE = new Point2D.Double(1.0, 1.0);
	private final static Point2D POSITION = new Point2D.Double(0.0, 0.0);
	private final static AffineTransform TRANSLATE = new AffineTransform();
	@Override
	public Point2D getScale(IElement e) {
		return SCALE;
	}

	@Override
	public Point2D getPosition(IElement e) {
		return POSITION;
	}

	@Override
	public AffineTransform getTransform(IElement e) {
		return TRANSLATE;
	}
	
	@Override
	public void moveTo(IElement e, double x, double y) {
		BendsHandler 	bends	= e.getElementClass().getSingleItem(BendsHandler.class);
		Path2D		path	= bends.getPath(e);
		AffineTransform at	= new AffineTransform();
		at.translate(x, y);
		Path2D		newPath	= new Path2D.Double(path, at);
		bends.setPath(e, newPath);
	}

	@Override
	public void setScale(IElement e, Point2D newScale) {
		BendsHandler 	bends	= e.getElementClass().getSingleItem(BendsHandler.class);
		Path2D		path	= bends.getPath(e);
		AffineTransform at	= new AffineTransform();
		at.scale(newScale.getX(), newScale.getY());		
		Path2D		newPath	= new Path2D.Double(path, at);
		bends.setPath(e, newPath);

	}

	@Override
	public void setTransform(IElement e, AffineTransform at) {
		BendsHandler 	bends	= e.getElementClass().getSingleItem(BendsHandler.class);
		Path2D		path	= bends.getPath(e);
		Path2D		newPath	= new Path2D.Double(path, at);
		bends.setPath(e, newPath);
	}
	

}
