/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass;

import java.awt.Color;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.Resizeable;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;

/**
 * Transparent film
 * 
 * @author Toni Kalajainen
 */
public class FilmClass {

	public static final Color FILM_COLOR =
		new Color(0.f, 0.f, 0.f, 0.5f);
	
	public static final ElementClass FILM_CLASS =
		ElementClass.compile(
				DefaultTransform.INSTANCE,
				Resizeable.UNCONSTRICTED,
				//HandleMouseEvent.EVENT_CONSUMER,
				FillColorImpl.handlerOf(FILM_COLOR), 
				new FilmSGNode()
				);
	
	static class FilmSGNode implements SceneGraph {
		/**
		 * 
		 */
		private static final long serialVersionUID = -7763377402727204557L;
		private ShapeNode node = null;
		
		@Override
		public void cleanup(IElement e) {
			if(node != null) {
				node.remove();
			}
			node = null;
		}

		@Override
		public void init(IElement e, G2DParentNode parent) {
			if(node == null) {
				node = parent.addNode(ShapeNode.class);
			}
			Color 		fillColor 	= ElementUtils.getFillColor(e);			
			Rectangle2D rect		= ElementUtils.getElementBounds(e);		
			
			node.setColor(fillColor);
			node.setFill(true);
			node.setShape(rect);
		}		
	}
	
}
