/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.util.Collection;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Validator;

/**
 * @author Toni Kalajainen
 */
public class ProxyValidator implements Validator {

    private static final long serialVersionUID = -8400810959985723213L;

    Validator orig;
    IProxyProvider provider;

    public ProxyValidator(IProxyProvider provider, Validator orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public void validate(IElement e, ICanvasContext ctx, Collection<Issue> lst) {
        orig.validate(provider.provide(e), ctx, lst);
    }

}
