/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

import org.simantics.g2d.diagram.handler.PickRequest.PickPolicy;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.utils.PathUtils;

public class ShapePick implements Pick {

    public final static ShapePick INSTANCE = new ShapePick();

    private static final long serialVersionUID = 1L;

    @Override
    public boolean pickTest(IElement e, Shape s, PickPolicy policy) {
        Rectangle2D pickRect = null;
        if (s instanceof Rectangle2D)
            pickRect = (Rectangle2D) s;
        else
            // FIXME: suboptimal, but works.
            pickRect = s.getBounds2D();

        Shape es = ElementUtils.getElementShapeOrBounds(e);
        // getElementShapeOrBounds returns shape or bounds in local coords!
        es = ElementUtils.getTransform(e).createTransformedShape(es);
        PathIterator iter = es.getPathIterator(null);
        Collection<double[]> segments = new ArrayList<double[]>();
        PathUtils.toLineSegments(iter, segments);

        switch (policy) {
            case PICK_CONTAINED_OBJECTS:
                for (double[] seg : segments) {
                    if (!pickRect.contains(seg[0], seg[1]) || !pickRect.contains(seg[2], seg[3]))
                        return false;
                }
                return true;

            case PICK_INTERSECTING_OBJECTS:
                for (double[] seg : segments) {
                    if (pickRect.intersectsLine(seg[0], seg[1], seg[2], seg[3]))
                        return true;
                    if (pickRect.contains(seg[0], seg[1]))
                    	return true;
                    if (pickRect.contains(seg[2], seg[3]))
                    	return true;
                }
                
                return false;
        }

        return false;
    }

}
