/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.util.Collection;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;

/**
 * This interface is implemented by all element contributions that
 * have fields to be validated. 
 * 
 * @author Toni Kalajainen
 */
public interface Validator extends ElementHandler {
	
	public interface Suggestion {
		String 	getMessage(IElement e, ICanvasContext ctx);
		/**
		 * 
		 * @param e
		 * @param ctx
		 * @return
		 */
		boolean fix(IElement e, ICanvasContext ctx);
	}
	
	public interface Issue {
		String 	getMessage(IElement e, ICanvasContext ctx);
		/**
		 * 
		 * @param e
		 * @param ctx
		 * @param suggestionList instances are should be static, shareable 
		 */
		void 	addSuggestions(IElement e, ICanvasContext ctx, Collection<Suggestion> suggestionList);
	}
		
	void validate(IElement e, ICanvasContext ctx, Collection<Issue> lst);	

}
